/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig;

@SdkInternalApi
public class InstanceGroupModifyConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupId").build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").build();
    private static final MarshallingInfo<List> EC2INSTANCEIDSTOTERMINATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2InstanceIdsToTerminate").build();
    private static final MarshallingInfo<StructuredPojo> SHRINKPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShrinkPolicy").build();
    private static final InstanceGroupModifyConfigMarshaller INSTANCE = new InstanceGroupModifyConfigMarshaller();

    public static InstanceGroupModifyConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroupModifyConfig instanceGroupModifyConfig, ProtocolMarshaller protocolMarshaller) {
        if (instanceGroupModifyConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.instanceGroupId(), INSTANCEGROUPID_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(instanceGroupModifyConfig.ec2InstanceIdsToTerminate(), EC2INSTANCEIDSTOTERMINATE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.shrinkPolicy(), SHRINKPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

