/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;

public final class ListInstancesPaginator
implements SdkIterable<ListInstancesResponse> {
    private final EMRClient client;
    private final ListInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstancesPaginator(EMRClient client, ListInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public Iterator<ListInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Instance> instances() {
        Function<ListInstancesResponse, Iterator> getIterator = response -> response != null ? response.instances().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInstancesResponseFetcher
    implements NextPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListInstancesResponse nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesPaginator.this.client.listInstances(ListInstancesPaginator.this.firstRequest);
            }
            return ListInstancesPaginator.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

