/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;

public final class ListInstanceGroupsPaginator
implements SdkIterable<ListInstanceGroupsResponse> {
    private final EMRClient client;
    private final ListInstanceGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstanceGroupsPaginator(EMRClient client, ListInstanceGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceGroupsResponseFetcher();
    }

    public Iterator<ListInstanceGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceGroup> instanceGroups() {
        Function<ListInstanceGroupsResponse, Iterator> getIterator = response -> response != null ? response.instanceGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInstanceGroupsResponseFetcher
    implements NextPageFetcher<ListInstanceGroupsResponse> {
        private ListInstanceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListInstanceGroupsResponse nextPage(ListInstanceGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceGroupsPaginator.this.client.listInstanceGroups(ListInstanceGroupsPaginator.this.firstRequest);
            }
            return ListInstanceGroupsPaginator.this.client.listInstanceGroups((ListInstanceGroupsRequest)((Object)ListInstanceGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

