/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.BootstrapActionDetail;
import software.amazon.awssdk.services.emr.model.BootstrapActionDetailListCopier;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionStatusDetail;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesDetail;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.StepDetail;
import software.amazon.awssdk.services.emr.model.StepDetailListCopier;
import software.amazon.awssdk.services.emr.model.SupportedProductsListCopier;
import software.amazon.awssdk.services.emr.transform.JobFlowDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobFlowDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobFlowDetail> {
    private final String jobFlowId;
    private final String name;
    private final String logUri;
    private final String amiVersion;
    private final JobFlowExecutionStatusDetail executionStatusDetail;
    private final JobFlowInstancesDetail instances;
    private final List<StepDetail> steps;
    private final List<BootstrapActionDetail> bootstrapActions;
    private final List<String> supportedProducts;
    private final Boolean visibleToAllUsers;
    private final String jobFlowRole;
    private final String serviceRole;
    private final String autoScalingRole;
    private final String scaleDownBehavior;

    private JobFlowDetail(BuilderImpl builder) {
        this.jobFlowId = builder.jobFlowId;
        this.name = builder.name;
        this.logUri = builder.logUri;
        this.amiVersion = builder.amiVersion;
        this.executionStatusDetail = builder.executionStatusDetail;
        this.instances = builder.instances;
        this.steps = builder.steps;
        this.bootstrapActions = builder.bootstrapActions;
        this.supportedProducts = builder.supportedProducts;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.jobFlowRole = builder.jobFlowRole;
        this.serviceRole = builder.serviceRole;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public String name() {
        return this.name;
    }

    public String logUri() {
        return this.logUri;
    }

    public String amiVersion() {
        return this.amiVersion;
    }

    public JobFlowExecutionStatusDetail executionStatusDetail() {
        return this.executionStatusDetail;
    }

    public JobFlowInstancesDetail instances() {
        return this.instances;
    }

    public List<StepDetail> steps() {
        return this.steps;
    }

    public List<BootstrapActionDetail> bootstrapActions() {
        return this.bootstrapActions;
    }

    public List<String> supportedProducts() {
        return this.supportedProducts;
    }

    public Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String jobFlowRole() {
        return this.jobFlowRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String autoScalingRole() {
        return this.autoScalingRole;
    }

    public ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(this.scaleDownBehavior);
    }

    public String scaleDownBehaviorString() {
        return this.scaleDownBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.steps());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleDownBehaviorString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowDetail)) {
            return false;
        }
        JobFlowDetail other = (JobFlowDetail)obj;
        return Objects.equals(this.jobFlowId(), other.jobFlowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.amiVersion(), other.amiVersion()) && Objects.equals(this.executionStatusDetail(), other.executionStatusDetail()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.bootstrapActions(), other.bootstrapActions()) && Objects.equals(this.supportedProducts(), other.supportedProducts()) && Objects.equals(this.visibleToAllUsers(), other.visibleToAllUsers()) && Objects.equals(this.jobFlowRole(), other.jobFlowRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.autoScalingRole(), other.autoScalingRole()) && Objects.equals(this.scaleDownBehaviorString(), other.scaleDownBehaviorString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.amiVersion() != null) {
            sb.append("AmiVersion: ").append(this.amiVersion()).append(",");
        }
        if (this.executionStatusDetail() != null) {
            sb.append("ExecutionStatusDetail: ").append(this.executionStatusDetail()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        if (this.bootstrapActions() != null) {
            sb.append("BootstrapActions: ").append(this.bootstrapActions()).append(",");
        }
        if (this.supportedProducts() != null) {
            sb.append("SupportedProducts: ").append(this.supportedProducts()).append(",");
        }
        if (this.visibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: ").append(this.visibleToAllUsers()).append(",");
        }
        if (this.jobFlowRole() != null) {
            sb.append("JobFlowRole: ").append(this.jobFlowRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.autoScalingRole() != null) {
            sb.append("AutoScalingRole: ").append(this.autoScalingRole()).append(",");
        }
        if (this.scaleDownBehaviorString() != null) {
            sb.append("ScaleDownBehavior: ").append(this.scaleDownBehaviorString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowId": {
                return Optional.of(clazz.cast(this.jobFlowId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "AmiVersion": {
                return Optional.of(clazz.cast(this.amiVersion()));
            }
            case "ExecutionStatusDetail": {
                return Optional.of(clazz.cast(this.executionStatusDetail()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "Steps": {
                return Optional.of(clazz.cast(this.steps()));
            }
            case "BootstrapActions": {
                return Optional.of(clazz.cast(this.bootstrapActions()));
            }
            case "SupportedProducts": {
                return Optional.of(clazz.cast(this.supportedProducts()));
            }
            case "VisibleToAllUsers": {
                return Optional.of(clazz.cast(this.visibleToAllUsers()));
            }
            case "JobFlowRole": {
                return Optional.of(clazz.cast(this.jobFlowRole()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "AutoScalingRole": {
                return Optional.of(clazz.cast(this.autoScalingRole()));
            }
            case "ScaleDownBehavior": {
                return Optional.of(clazz.cast(this.scaleDownBehaviorString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobFlowDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobFlowId;
        private String name;
        private String logUri;
        private String amiVersion;
        private JobFlowExecutionStatusDetail executionStatusDetail;
        private JobFlowInstancesDetail instances;
        private List<StepDetail> steps;
        private List<BootstrapActionDetail> bootstrapActions;
        private List<String> supportedProducts;
        private Boolean visibleToAllUsers;
        private String jobFlowRole;
        private String serviceRole;
        private String autoScalingRole;
        private String scaleDownBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowDetail model) {
            this.jobFlowId(model.jobFlowId);
            this.name(model.name);
            this.logUri(model.logUri);
            this.amiVersion(model.amiVersion);
            this.executionStatusDetail(model.executionStatusDetail);
            this.instances(model.instances);
            this.steps(model.steps);
            this.bootstrapActions(model.bootstrapActions);
            this.supportedProducts(model.supportedProducts);
            this.visibleToAllUsers(model.visibleToAllUsers);
            this.jobFlowRole(model.jobFlowRole);
            this.serviceRole(model.serviceRole);
            this.autoScalingRole(model.autoScalingRole);
            this.scaleDownBehavior(model.scaleDownBehavior);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getAmiVersion() {
            return this.amiVersion;
        }

        @Override
        public final Builder amiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
            return this;
        }

        public final void setAmiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
        }

        public final JobFlowExecutionStatusDetail.Builder getExecutionStatusDetail() {
            return this.executionStatusDetail != null ? this.executionStatusDetail.toBuilder() : null;
        }

        @Override
        public final Builder executionStatusDetail(JobFlowExecutionStatusDetail executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail;
            return this;
        }

        public final void setExecutionStatusDetail(JobFlowExecutionStatusDetail.BuilderImpl executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail != null ? executionStatusDetail.build() : null;
        }

        public final JobFlowInstancesDetail.Builder getInstances() {
            return this.instances != null ? this.instances.toBuilder() : null;
        }

        @Override
        public final Builder instances(JobFlowInstancesDetail instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(JobFlowInstancesDetail.BuilderImpl instances) {
            this.instances = instances != null ? instances.build() : null;
        }

        public final Collection<StepDetail.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(StepDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepDetail> steps) {
            this.steps = StepDetailListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepDetail ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        public final void setSteps(Collection<StepDetail.BuilderImpl> steps) {
            this.steps = StepDetailListCopier.copyFromBuilder(steps);
        }

        public final Collection<BootstrapActionDetail.Builder> getBootstrapActions() {
            return this.bootstrapActions != null ? (Collection)this.bootstrapActions.stream().map(BootstrapActionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<BootstrapActionDetail> bootstrapActions) {
            this.bootstrapActions = BootstrapActionDetailListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(BootstrapActionDetail ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        public final void setBootstrapActions(Collection<BootstrapActionDetail.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = BootstrapActionDetailListCopier.copyFromBuilder(bootstrapActions);
        }

        public final Collection<String> getSupportedProducts() {
            return this.supportedProducts;
        }

        @Override
        public final Builder supportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedProducts(String ... supportedProducts) {
            this.supportedProducts(Arrays.asList(supportedProducts));
            return this;
        }

        public final void setSupportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final String getJobFlowRole() {
            return this.jobFlowRole;
        }

        @Override
        public final Builder jobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        public final void setJobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public JobFlowDetail build() {
            return new JobFlowDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobFlowDetail> {
        public Builder jobFlowId(String var1);

        public Builder name(String var1);

        public Builder logUri(String var1);

        public Builder amiVersion(String var1);

        public Builder executionStatusDetail(JobFlowExecutionStatusDetail var1);

        default public Builder executionStatusDetail(Consumer<JobFlowExecutionStatusDetail.Builder> executionStatusDetail) {
            return this.executionStatusDetail((JobFlowExecutionStatusDetail)((JobFlowExecutionStatusDetail.Builder)JobFlowExecutionStatusDetail.builder().apply(executionStatusDetail)).build());
        }

        public Builder instances(JobFlowInstancesDetail var1);

        default public Builder instances(Consumer<JobFlowInstancesDetail.Builder> instances) {
            return this.instances((JobFlowInstancesDetail)((JobFlowInstancesDetail.Builder)JobFlowInstancesDetail.builder().apply(instances)).build());
        }

        public Builder steps(Collection<StepDetail> var1);

        public Builder steps(StepDetail ... var1);

        public Builder bootstrapActions(Collection<BootstrapActionDetail> var1);

        public Builder bootstrapActions(BootstrapActionDetail ... var1);

        public Builder supportedProducts(Collection<String> var1);

        public Builder supportedProducts(String ... var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder jobFlowRole(String var1);

        public Builder serviceRole(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);
    }
}

