/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.StringMapCopier;
import software.amazon.awssdk.services.emr.transform.ConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Configuration
implements StructuredPojo,
ToCopyableBuilder<Builder, Configuration> {
    private final String classification;
    private final List<Configuration> configurations;
    private final Map<String, String> properties;

    private Configuration(BuilderImpl builder) {
        this.classification = builder.classification;
        this.configurations = builder.configurations;
        this.properties = builder.properties;
    }

    public String classification() {
        return this.classification;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Objects.equals(this.classification(), other.classification()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.properties(), other.properties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.classification() != null) {
            sb.append("Classification: ").append(this.classification()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.properties() != null) {
            sb.append("Properties: ").append(this.properties()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classification": {
                return Optional.of(clazz.cast(this.classification()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "Properties": {
                return Optional.of(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String classification;
        private List<Configuration> configurations;
        private Map<String, String> properties;

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            this.classification(model.classification);
            this.configurations(model.configurations);
            this.properties(model.properties);
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final Collection<Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Configuration> {
        public Builder classification(String var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder properties(Map<String, String> var1);
    }
}

