/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.FailureDetails;
import software.amazon.awssdk.services.emr.model.StepState;
import software.amazon.awssdk.services.emr.model.StepStateChangeReason;
import software.amazon.awssdk.services.emr.model.StepTimeline;
import software.amazon.awssdk.services.emr.transform.StepStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, StepStatus> {
    private final String state;
    private final StepStateChangeReason stateChangeReason;
    private final FailureDetails failureDetails;
    private final StepTimeline timeline;

    private StepStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.failureDetails = builder.failureDetails;
        this.timeline = builder.timeline;
    }

    public StepState state() {
        return StepState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public StepStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public StepTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.failureDetails() == null ? 0 : this.failureDetails().hashCode());
        hashCode = 31 * hashCode + (this.timeline() == null ? 0 : this.timeline().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepStatus)) {
            return false;
        }
        StepStatus other = (StepStatus)obj;
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.failureDetails() == null ^ this.failureDetails() == null) {
            return false;
        }
        if (other.failureDetails() != null && !other.failureDetails().equals(this.failureDetails())) {
            return false;
        }
        if (other.timeline() == null ^ this.timeline() == null) {
            return false;
        }
        return other.timeline() == null || other.timeline().equals(this.timeline());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.failureDetails() != null) {
            sb.append("FailureDetails: ").append(this.failureDetails()).append(",");
        }
        if (this.timeline() != null) {
            sb.append("Timeline: ").append(this.timeline()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "FailureDetails": {
                return Optional.of(clazz.cast(this.failureDetails()));
            }
            case "Timeline": {
                return Optional.of(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private StepStateChangeReason stateChangeReason;
        private FailureDetails failureDetails;
        private StepTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(StepStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.failureDetails(model.failureDetails);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StepState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final StepStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(StepStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(StepStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        public final StepTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(StepTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(StepTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public StepStatus build() {
            return new StepStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepStatus> {
        public Builder state(String var1);

        public Builder state(StepState var1);

        public Builder stateChangeReason(StepStateChangeReason var1);

        public Builder failureDetails(FailureDetails var1);

        public Builder timeline(StepTimeline var1);
    }
}

