/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AdjustmentType;
import software.amazon.awssdk.services.emr.transform.SimpleScalingPolicyConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SimpleScalingPolicyConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
    private final String adjustmentType;
    private final Integer scalingAdjustment;
    private final Integer coolDown;

    private SimpleScalingPolicyConfiguration(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.coolDown = builder.coolDown;
    }

    public AdjustmentType adjustmentType() {
        return AdjustmentType.fromValue(this.adjustmentType);
    }

    public String adjustmentTypeString() {
        return this.adjustmentType;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Integer coolDown() {
        return this.coolDown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.adjustmentTypeString() == null ? 0 : this.adjustmentTypeString().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustment() == null ? 0 : this.scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.coolDown() == null ? 0 : this.coolDown().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleScalingPolicyConfiguration)) {
            return false;
        }
        SimpleScalingPolicyConfiguration other = (SimpleScalingPolicyConfiguration)obj;
        if (other.adjustmentTypeString() == null ^ this.adjustmentTypeString() == null) {
            return false;
        }
        if (other.adjustmentTypeString() != null && !other.adjustmentTypeString().equals(this.adjustmentTypeString())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.coolDown() == null ^ this.coolDown() == null) {
            return false;
        }
        return other.coolDown() == null || other.coolDown().equals(this.coolDown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.adjustmentTypeString() != null) {
            sb.append("AdjustmentType: ").append(this.adjustmentTypeString()).append(",");
        }
        if (this.scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.scalingAdjustment()).append(",");
        }
        if (this.coolDown() != null) {
            sb.append("CoolDown: ").append(this.coolDown()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentType": {
                return Optional.of(clazz.cast(this.adjustmentTypeString()));
            }
            case "ScalingAdjustment": {
                return Optional.of(clazz.cast(this.scalingAdjustment()));
            }
            case "CoolDown": {
                return Optional.of(clazz.cast(this.coolDown()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SimpleScalingPolicyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String adjustmentType;
        private Integer scalingAdjustment;
        private Integer coolDown;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleScalingPolicyConfiguration model) {
            this.adjustmentType(model.adjustmentType);
            this.scalingAdjustment(model.scalingAdjustment);
            this.coolDown(model.coolDown);
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        @Override
        public final Builder adjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCoolDown() {
            return this.coolDown;
        }

        @Override
        public final Builder coolDown(Integer coolDown) {
            this.coolDown = coolDown;
            return this;
        }

        public final void setCoolDown(Integer coolDown) {
            this.coolDown = coolDown;
        }

        public SimpleScalingPolicyConfiguration build() {
            return new SimpleScalingPolicyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
        public Builder adjustmentType(String var1);

        public Builder adjustmentType(AdjustmentType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder coolDown(Integer var1);
    }
}

