/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.services.emr.transform.ScriptBootstrapActionConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScriptBootstrapActionConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ScriptBootstrapActionConfig> {
    private final String path;
    private final List<String> args;

    private ScriptBootstrapActionConfig(BuilderImpl builder) {
        this.path = builder.path;
        this.args = builder.args;
    }

    public String path() {
        return this.path;
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.args() == null ? 0 : this.args().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptBootstrapActionConfig)) {
            return false;
        }
        ScriptBootstrapActionConfig other = (ScriptBootstrapActionConfig)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        return other.args() == null || other.args().equals(this.args());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.args() != null) {
            sb.append("Args: ").append(this.args()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "Args": {
                return Optional.of(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScriptBootstrapActionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<String> args;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptBootstrapActionConfig model) {
            this.path(model.path);
            this.args(model.args);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        public ScriptBootstrapActionConfig build() {
            return new ScriptBootstrapActionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScriptBootstrapActionConfig> {
        public Builder path(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

