/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.ClusterSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private final List<ClusterSummary> clusters;
    private final String marker;

    private ListClustersResponse(BuilderImpl builder) {
        this.clusters = builder.clusters;
        this.marker = builder.marker;
    }

    public List<ClusterSummary> clusters() {
        return this.clusters;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusters() == null ? 0 : this.clusters().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        if (other.clusters() == null ^ this.clusters() == null) {
            return false;
        }
        if (other.clusters() != null && !other.clusters().equals(this.clusters())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusters() != null) {
            sb.append("Clusters: ").append(this.clusters()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clusters": {
                return Optional.of(clazz.cast(this.clusters()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ClusterSummary> clusters;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            this.clusters(model.clusters);
            this.marker(model.marker);
        }

        public final Collection<ClusterSummary.Builder> getClusters() {
            return this.clusters != null ? (Collection)this.clusters.stream().map(ClusterSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<ClusterSummary> clusters) {
            this.clusters = ClusterSummaryListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(ClusterSummary ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final void setClusters(Collection<ClusterSummary.BuilderImpl> clusters) {
            this.clusters = ClusterSummaryListCopier.copyFromBuilder(clusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusters(Collection<ClusterSummary> var1);

        public Builder clusters(ClusterSummary ... var1);

        public Builder marker(String var1);
    }
}

