/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.services.emr.transform.InstanceTypeConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceTypeConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceTypeConfig> {
    private final String instanceType;
    private final Integer weightedCapacity;
    private final String bidPrice;
    private final Double bidPriceAsPercentageOfOnDemandPrice;
    private final EbsConfiguration ebsConfiguration;
    private final List<Configuration> configurations;

    private InstanceTypeConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.bidPrice = builder.bidPrice;
        this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.configurations = builder.configurations;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer weightedCapacity() {
        return this.weightedCapacity;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public Double bidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.weightedCapacity() == null ? 0 : this.weightedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.bidPrice() == null ? 0 : this.bidPrice().hashCode());
        hashCode = 31 * hashCode + (this.bidPriceAsPercentageOfOnDemandPrice() == null ? 0 : this.bidPriceAsPercentageOfOnDemandPrice().hashCode());
        hashCode = 31 * hashCode + (this.ebsConfiguration() == null ? 0 : this.ebsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeConfig)) {
            return false;
        }
        InstanceTypeConfig other = (InstanceTypeConfig)obj;
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.weightedCapacity() == null ^ this.weightedCapacity() == null) {
            return false;
        }
        if (other.weightedCapacity() != null && !other.weightedCapacity().equals(this.weightedCapacity())) {
            return false;
        }
        if (other.bidPrice() == null ^ this.bidPrice() == null) {
            return false;
        }
        if (other.bidPrice() != null && !other.bidPrice().equals(this.bidPrice())) {
            return false;
        }
        if (other.bidPriceAsPercentageOfOnDemandPrice() == null ^ this.bidPriceAsPercentageOfOnDemandPrice() == null) {
            return false;
        }
        if (other.bidPriceAsPercentageOfOnDemandPrice() != null && !other.bidPriceAsPercentageOfOnDemandPrice().equals(this.bidPriceAsPercentageOfOnDemandPrice())) {
            return false;
        }
        if (other.ebsConfiguration() == null ^ this.ebsConfiguration() == null) {
            return false;
        }
        if (other.ebsConfiguration() != null && !other.ebsConfiguration().equals(this.ebsConfiguration())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        return other.configurations() == null || other.configurations().equals(this.configurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.weightedCapacity() != null) {
            sb.append("WeightedCapacity: ").append(this.weightedCapacity()).append(",");
        }
        if (this.bidPrice() != null) {
            sb.append("BidPrice: ").append(this.bidPrice()).append(",");
        }
        if (this.bidPriceAsPercentageOfOnDemandPrice() != null) {
            sb.append("BidPriceAsPercentageOfOnDemandPrice: ").append(this.bidPriceAsPercentageOfOnDemandPrice()).append(",");
        }
        if (this.ebsConfiguration() != null) {
            sb.append("EbsConfiguration: ").append(this.ebsConfiguration()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.of(clazz.cast(this.weightedCapacity()));
            }
            case "BidPrice": {
                return Optional.of(clazz.cast(this.bidPrice()));
            }
            case "BidPriceAsPercentageOfOnDemandPrice": {
                return Optional.of(clazz.cast(this.bidPriceAsPercentageOfOnDemandPrice()));
            }
            case "EbsConfiguration": {
                return Optional.of(clazz.cast(this.ebsConfiguration()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceTypeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer weightedCapacity;
        private String bidPrice;
        private Double bidPriceAsPercentageOfOnDemandPrice;
        private EbsConfiguration ebsConfiguration;
        private List<Configuration> configurations;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeConfig model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.bidPrice(model.bidPrice);
            this.bidPriceAsPercentageOfOnDemandPrice(model.bidPriceAsPercentageOfOnDemandPrice);
            this.ebsConfiguration(model.ebsConfiguration);
            this.configurations(model.configurations);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final Double getBidPriceAsPercentageOfOnDemandPrice() {
            return this.bidPriceAsPercentageOfOnDemandPrice;
        }

        @Override
        public final Builder bidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        public final void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
        }

        public final EbsConfiguration.Builder getEbsConfiguration() {
            return this.ebsConfiguration != null ? this.ebsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final void setEbsConfiguration(EbsConfiguration.BuilderImpl ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration != null ? ebsConfiguration.build() : null;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public InstanceTypeConfig build() {
            return new InstanceTypeConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceTypeConfig> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(Integer var1);

        public Builder bidPrice(String var1);

        public Builder bidPriceAsPercentageOfOnDemandPrice(Double var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);
    }
}

