/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.InstanceGroupTimelineMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupTimeline
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupTimeline> {
    private final Instant creationDateTime;
    private final Instant readyDateTime;
    private final Instant endDateTime;

    private InstanceGroupTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant readyDateTime() {
        return this.readyDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.readyDateTime() == null ? 0 : this.readyDateTime().hashCode());
        hashCode = 31 * hashCode + (this.endDateTime() == null ? 0 : this.endDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupTimeline)) {
            return false;
        }
        InstanceGroupTimeline other = (InstanceGroupTimeline)obj;
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        if (other.creationDateTime() != null && !other.creationDateTime().equals(this.creationDateTime())) {
            return false;
        }
        if (other.readyDateTime() == null ^ this.readyDateTime() == null) {
            return false;
        }
        if (other.readyDateTime() != null && !other.readyDateTime().equals(this.readyDateTime())) {
            return false;
        }
        if (other.endDateTime() == null ^ this.endDateTime() == null) {
            return false;
        }
        return other.endDateTime() == null || other.endDateTime().equals(this.endDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (this.readyDateTime() != null) {
            sb.append("ReadyDateTime: ").append(this.readyDateTime()).append(",");
        }
        if (this.endDateTime() != null) {
            sb.append("EndDateTime: ").append(this.endDateTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDateTime": {
                return Optional.of(clazz.cast(this.creationDateTime()));
            }
            case "ReadyDateTime": {
                return Optional.of(clazz.cast(this.readyDateTime()));
            }
            case "EndDateTime": {
                return Optional.of(clazz.cast(this.endDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupTimelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDateTime;
        private Instant readyDateTime;
        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupTimeline model) {
            this.creationDateTime(model.creationDateTime);
            this.readyDateTime(model.readyDateTime);
            this.endDateTime(model.endDateTime);
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getReadyDateTime() {
            return this.readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
            return this;
        }

        public final void setReadyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public InstanceGroupTimeline build() {
            return new InstanceGroupTimeline(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupTimeline> {
        public Builder creationDateTime(Instant var1);

        public Builder readyDateTime(Instant var1);

        public Builder endDateTime(Instant var1);
    }
}

