/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetStatus;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecification;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecificationListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceFleetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceFleet
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleet> {
    private final String id;
    private final String name;
    private final InstanceFleetStatus status;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final Integer provisionedOnDemandCapacity;
    private final Integer provisionedSpotCapacity;
    private final List<InstanceTypeSpecification> instanceTypeSpecifications;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;

    private InstanceFleet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.provisionedOnDemandCapacity = builder.provisionedOnDemandCapacity;
        this.provisionedSpotCapacity = builder.provisionedSpotCapacity;
        this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
        this.launchSpecifications = builder.launchSpecifications;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public InstanceFleetStatus status() {
        return this.status;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeString() {
        return this.instanceFleetType;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public Integer provisionedOnDemandCapacity() {
        return this.provisionedOnDemandCapacity;
    }

    public Integer provisionedSpotCapacity() {
        return this.provisionedSpotCapacity;
    }

    public List<InstanceTypeSpecification> instanceTypeSpecifications() {
        return this.instanceTypeSpecifications;
    }

    public InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleetTypeString() == null ? 0 : this.instanceFleetTypeString().hashCode());
        hashCode = 31 * hashCode + (this.targetOnDemandCapacity() == null ? 0 : this.targetOnDemandCapacity().hashCode());
        hashCode = 31 * hashCode + (this.targetSpotCapacity() == null ? 0 : this.targetSpotCapacity().hashCode());
        hashCode = 31 * hashCode + (this.provisionedOnDemandCapacity() == null ? 0 : this.provisionedOnDemandCapacity().hashCode());
        hashCode = 31 * hashCode + (this.provisionedSpotCapacity() == null ? 0 : this.provisionedSpotCapacity().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeSpecifications() == null ? 0 : this.instanceTypeSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecifications() == null ? 0 : this.launchSpecifications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleet)) {
            return false;
        }
        InstanceFleet other = (InstanceFleet)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.instanceFleetTypeString() == null ^ this.instanceFleetTypeString() == null) {
            return false;
        }
        if (other.instanceFleetTypeString() != null && !other.instanceFleetTypeString().equals(this.instanceFleetTypeString())) {
            return false;
        }
        if (other.targetOnDemandCapacity() == null ^ this.targetOnDemandCapacity() == null) {
            return false;
        }
        if (other.targetOnDemandCapacity() != null && !other.targetOnDemandCapacity().equals(this.targetOnDemandCapacity())) {
            return false;
        }
        if (other.targetSpotCapacity() == null ^ this.targetSpotCapacity() == null) {
            return false;
        }
        if (other.targetSpotCapacity() != null && !other.targetSpotCapacity().equals(this.targetSpotCapacity())) {
            return false;
        }
        if (other.provisionedOnDemandCapacity() == null ^ this.provisionedOnDemandCapacity() == null) {
            return false;
        }
        if (other.provisionedOnDemandCapacity() != null && !other.provisionedOnDemandCapacity().equals(this.provisionedOnDemandCapacity())) {
            return false;
        }
        if (other.provisionedSpotCapacity() == null ^ this.provisionedSpotCapacity() == null) {
            return false;
        }
        if (other.provisionedSpotCapacity() != null && !other.provisionedSpotCapacity().equals(this.provisionedSpotCapacity())) {
            return false;
        }
        if (other.instanceTypeSpecifications() == null ^ this.instanceTypeSpecifications() == null) {
            return false;
        }
        if (other.instanceTypeSpecifications() != null && !other.instanceTypeSpecifications().equals(this.instanceTypeSpecifications())) {
            return false;
        }
        if (other.launchSpecifications() == null ^ this.launchSpecifications() == null) {
            return false;
        }
        return other.launchSpecifications() == null || other.launchSpecifications().equals(this.launchSpecifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.instanceFleetTypeString() != null) {
            sb.append("InstanceFleetType: ").append(this.instanceFleetTypeString()).append(",");
        }
        if (this.targetOnDemandCapacity() != null) {
            sb.append("TargetOnDemandCapacity: ").append(this.targetOnDemandCapacity()).append(",");
        }
        if (this.targetSpotCapacity() != null) {
            sb.append("TargetSpotCapacity: ").append(this.targetSpotCapacity()).append(",");
        }
        if (this.provisionedOnDemandCapacity() != null) {
            sb.append("ProvisionedOnDemandCapacity: ").append(this.provisionedOnDemandCapacity()).append(",");
        }
        if (this.provisionedSpotCapacity() != null) {
            sb.append("ProvisionedSpotCapacity: ").append(this.provisionedSpotCapacity()).append(",");
        }
        if (this.instanceTypeSpecifications() != null) {
            sb.append("InstanceTypeSpecifications: ").append(this.instanceTypeSpecifications()).append(",");
        }
        if (this.launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.launchSpecifications()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "InstanceFleetType": {
                return Optional.of(clazz.cast(this.instanceFleetTypeString()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.of(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.of(clazz.cast(this.targetSpotCapacity()));
            }
            case "ProvisionedOnDemandCapacity": {
                return Optional.of(clazz.cast(this.provisionedOnDemandCapacity()));
            }
            case "ProvisionedSpotCapacity": {
                return Optional.of(clazz.cast(this.provisionedSpotCapacity()));
            }
            case "InstanceTypeSpecifications": {
                return Optional.of(clazz.cast(this.instanceTypeSpecifications()));
            }
            case "LaunchSpecifications": {
                return Optional.of(clazz.cast(this.launchSpecifications()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private InstanceFleetStatus status;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private Integer provisionedOnDemandCapacity;
        private Integer provisionedSpotCapacity;
        private List<InstanceTypeSpecification> instanceTypeSpecifications;
        private InstanceFleetProvisioningSpecifications launchSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleet model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.instanceFleetType(model.instanceFleetType);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.provisionedOnDemandCapacity(model.provisionedOnDemandCapacity);
            this.provisionedSpotCapacity(model.provisionedSpotCapacity);
            this.instanceTypeSpecifications(model.instanceTypeSpecifications);
            this.launchSpecifications(model.launchSpecifications);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final InstanceFleetStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(InstanceFleetStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceFleetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public final Integer getProvisionedOnDemandCapacity() {
            return this.provisionedOnDemandCapacity;
        }

        @Override
        public final Builder provisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
            return this;
        }

        public final void setProvisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
        }

        public final Integer getProvisionedSpotCapacity() {
            return this.provisionedSpotCapacity;
        }

        @Override
        public final Builder provisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
            return this;
        }

        public final void setProvisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
        }

        public final Collection<InstanceTypeSpecification.Builder> getInstanceTypeSpecifications() {
            return this.instanceTypeSpecifications != null ? (Collection)this.instanceTypeSpecifications.stream().map(InstanceTypeSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copy(instanceTypeSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(InstanceTypeSpecification ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Arrays.asList(instanceTypeSpecifications));
            return this;
        }

        public final void setInstanceTypeSpecifications(Collection<InstanceTypeSpecification.BuilderImpl> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copyFromBuilder(instanceTypeSpecifications);
        }

        public final InstanceFleetProvisioningSpecifications.Builder getLaunchSpecifications() {
            return this.launchSpecifications != null ? this.launchSpecifications.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications.BuilderImpl launchSpecifications) {
            this.launchSpecifications = launchSpecifications != null ? launchSpecifications.build() : null;
        }

        public InstanceFleet build() {
            return new InstanceFleet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleet> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(InstanceFleetStatus var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder provisionedOnDemandCapacity(Integer var1);

        public Builder provisionedSpotCapacity(Integer var1);

        public Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> var1);

        public Builder instanceTypeSpecifications(InstanceTypeSpecification ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);
    }
}

