/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStepRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeStepRequest> {
    private final String clusterId;
    private final String stepId;

    private DescribeStepRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.stepId = builder.stepId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String stepId() {
        return this.stepId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.stepId() == null ? 0 : this.stepId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStepRequest)) {
            return false;
        }
        DescribeStepRequest other = (DescribeStepRequest)((Object)obj);
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.stepId() == null ^ this.stepId() == null) {
            return false;
        }
        return other.stepId() == null || other.stepId().equals(this.stepId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.stepId() != null) {
            sb.append("StepId: ").append(this.stepId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "StepId": {
                return Optional.of(clazz.cast(this.stepId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String stepId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStepRequest model) {
            this.clusterId(model.clusterId);
            this.stepId(model.stepId);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getStepId() {
            return this.stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        public DescribeStepRequest build() {
            return new DescribeStepRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStepRequest> {
        public Builder clusterId(String var1);

        public Builder stepId(String var1);
    }
}

