/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepDetail;

@SdkInternalApi
public class StepDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> STEPCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepConfig").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSTATUSDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStatusDetail").build();
    private static final StepDetailMarshaller INSTANCE = new StepDetailMarshaller();

    public static StepDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepDetail stepDetail, ProtocolMarshaller protocolMarshaller) {
        if (stepDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stepDetail.stepConfig(), STEPCONFIG_BINDING);
            protocolMarshaller.marshall((Object)stepDetail.executionStatusDetail(), EXECUTIONSTATUSDETAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

