/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroup;

@SdkInternalApi
public class InstanceGroupMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").build();
    private static final MarshallingInfo<String> INSTANCEGROUPTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupType").build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Integer> REQUESTEDINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedInstanceCount").build();
    private static final MarshallingInfo<Integer> RUNNINGINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunningInstanceCount").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").build();
    private static final MarshallingInfo<List> EBSBLOCKDEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsBlockDevices").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final MarshallingInfo<StructuredPojo> SHRINKPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShrinkPolicy").build();
    private static final MarshallingInfo<StructuredPojo> AUTOSCALINGPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingPolicy").build();
    private static final InstanceGroupMarshaller INSTANCE = new InstanceGroupMarshaller();

    public static InstanceGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroup instanceGroup, ProtocolMarshaller protocolMarshaller) {
        if (instanceGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceGroup.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.market(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.instanceGroupType(), INSTANCEGROUPTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.requestedInstanceCount(), REQUESTEDINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.runningInstanceCount(), RUNNINGINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.status(), STATUS_BINDING);
            protocolMarshaller.marshall(instanceGroup.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(instanceGroup.ebsBlockDevices(), EBSBLOCKDEVICES_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.shrinkPolicy(), SHRINKPOLICY_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.autoScalingPolicy(), AUTOSCALINGPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

