/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetTerminationProtectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetTerminationProtectionRequest> {
    private final List<String> jobFlowIds;
    private final Boolean terminationProtected;

    private SetTerminationProtectionRequest(BuilderImpl builder) {
        this.jobFlowIds = builder.jobFlowIds;
        this.terminationProtected = builder.terminationProtected;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobFlowIds() == null ? 0 : this.jobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.terminationProtected() == null ? 0 : this.terminationProtected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTerminationProtectionRequest)) {
            return false;
        }
        SetTerminationProtectionRequest other = (SetTerminationProtectionRequest)((Object)obj);
        if (other.jobFlowIds() == null ^ this.jobFlowIds() == null) {
            return false;
        }
        if (other.jobFlowIds() != null && !other.jobFlowIds().equals(this.jobFlowIds())) {
            return false;
        }
        if (other.terminationProtected() == null ^ this.terminationProtected() == null) {
            return false;
        }
        return other.terminationProtected() == null || other.terminationProtected().equals(this.terminationProtected());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobFlowIds() != null) {
            sb.append("JobFlowIds: ").append(this.jobFlowIds()).append(",");
        }
        if (this.terminationProtected() != null) {
            sb.append("TerminationProtected: ").append(this.terminationProtected()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> jobFlowIds;
        private Boolean terminationProtected;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTerminationProtectionRequest model) {
            this.setJobFlowIds(model.jobFlowIds);
            this.setTerminationProtected(model.terminationProtected);
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public SetTerminationProtectionRequest build() {
            return new SetTerminationProtectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetTerminationProtectionRequest> {
        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder terminationProtected(Boolean var1);
    }
}

