/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration;
import software.amazon.awssdk.services.emr.transform.ScalingActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingAction
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingAction> {
    private final String market;
    private final SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

    private ScalingAction(BuilderImpl builder) {
        this.market = builder.market;
        this.simpleScalingPolicyConfiguration = builder.simpleScalingPolicyConfiguration;
    }

    public String market() {
        return this.market;
    }

    public SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration() {
        return this.simpleScalingPolicyConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.market() == null ? 0 : this.market().hashCode());
        hashCode = 31 * hashCode + (this.simpleScalingPolicyConfiguration() == null ? 0 : this.simpleScalingPolicyConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingAction)) {
            return false;
        }
        ScalingAction other = (ScalingAction)obj;
        if (other.market() == null ^ this.market() == null) {
            return false;
        }
        if (other.market() != null && !other.market().equals(this.market())) {
            return false;
        }
        if (other.simpleScalingPolicyConfiguration() == null ^ this.simpleScalingPolicyConfiguration() == null) {
            return false;
        }
        return other.simpleScalingPolicyConfiguration() == null || other.simpleScalingPolicyConfiguration().equals(this.simpleScalingPolicyConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.market() != null) {
            sb.append("Market: ").append(this.market()).append(",");
        }
        if (this.simpleScalingPolicyConfiguration() != null) {
            sb.append("SimpleScalingPolicyConfiguration: ").append(this.simpleScalingPolicyConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String market;
        private SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingAction model) {
            this.setMarket(model.market);
            this.setSimpleScalingPolicyConfiguration(model.simpleScalingPolicyConfiguration);
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final SimpleScalingPolicyConfiguration getSimpleScalingPolicyConfiguration() {
            return this.simpleScalingPolicyConfiguration;
        }

        @Override
        public final Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
            return this;
        }

        public final void setSimpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
        }

        public ScalingAction build() {
            return new ScalingAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingAction> {
        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration var1);
    }
}

