/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.ClusterState;
import software.amazon.awssdk.services.emr.model.ClusterStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListClustersRequest> {
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> clusterStates;
    private final String marker;

    private ListClustersRequest(BuilderImpl builder) {
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.clusterStates = builder.clusterStates;
        this.marker = builder.marker;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<String> clusterStates() {
        return this.clusterStates;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createdAfter() == null ? 0 : this.createdAfter().hashCode());
        hashCode = 31 * hashCode + (this.createdBefore() == null ? 0 : this.createdBefore().hashCode());
        hashCode = 31 * hashCode + (this.clusterStates() == null ? 0 : this.clusterStates().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)((Object)obj);
        if (other.createdAfter() == null ^ this.createdAfter() == null) {
            return false;
        }
        if (other.createdAfter() != null && !other.createdAfter().equals(this.createdAfter())) {
            return false;
        }
        if (other.createdBefore() == null ^ this.createdBefore() == null) {
            return false;
        }
        if (other.createdBefore() != null && !other.createdBefore().equals(this.createdBefore())) {
            return false;
        }
        if (other.clusterStates() == null ^ this.clusterStates() == null) {
            return false;
        }
        if (other.clusterStates() != null && !other.clusterStates().equals(this.clusterStates())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createdAfter() != null) {
            sb.append("CreatedAfter: ").append(this.createdAfter()).append(",");
        }
        if (this.createdBefore() != null) {
            sb.append("CreatedBefore: ").append(this.createdBefore()).append(",");
        }
        if (this.clusterStates() != null) {
            sb.append("ClusterStates: ").append(this.clusterStates()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> clusterStates;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            this.setCreatedAfter(model.createdAfter);
            this.setCreatedBefore(model.createdBefore);
            this.setClusterStates(model.clusterStates);
            this.setMarker(model.marker);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getClusterStates() {
            return this.clusterStates;
        }

        @Override
        public final Builder clusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(String ... clusterStates) {
            this.clusterStates(Arrays.asList(clusterStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(ClusterState ... clusterStates) {
            this.clusterStates(Arrays.asList(clusterStates).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClustersRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder clusterStates(Collection<String> var1);

        public Builder clusterStates(String ... var1);

        public Builder clusterStates(ClusterState ... var1);

        public Builder marker(String var1);
    }
}

