/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.FailureDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailureDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, FailureDetails> {
    private final String reason;
    private final String message;
    private final String logFile;

    private FailureDetails(BuilderImpl builder) {
        this.reason = builder.reason;
        this.message = builder.message;
        this.logFile = builder.logFile;
    }

    public String reason() {
        return this.reason;
    }

    public String message() {
        return this.message;
    }

    public String logFile() {
        return this.logFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reason() == null ? 0 : this.reason().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.logFile() == null ? 0 : this.logFile().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        if (other.reason() != null && !other.reason().equals(this.reason())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.logFile() == null ^ this.logFile() == null) {
            return false;
        }
        return other.logFile() == null || other.logFile().equals(this.logFile());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.logFile() != null) {
            sb.append("LogFile: ").append(this.logFile()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String reason;
        private String message;
        private String logFile;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.setReason(model.reason);
            this.setMessage(model.message);
            this.setLogFile(model.logFile);
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogFile() {
            return this.logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public FailureDetails build() {
            return new FailureDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailureDetails> {
        public Builder reason(String var1);

        public Builder message(String var1);

        public Builder logFile(String var1);
    }
}

