/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringMaxLen256ListCopier;
import software.amazon.awssdk.services.emr.transform.Ec2InstanceAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Ec2InstanceAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, Ec2InstanceAttributes> {
    private final String ec2KeyName;
    private final String ec2SubnetId;
    private final List<String> requestedEc2SubnetIds;
    private final String ec2AvailabilityZone;
    private final List<String> requestedEc2AvailabilityZones;
    private final String iamInstanceProfile;
    private final String emrManagedMasterSecurityGroup;
    private final String emrManagedSlaveSecurityGroup;
    private final String serviceAccessSecurityGroup;
    private final List<String> additionalMasterSecurityGroups;
    private final List<String> additionalSlaveSecurityGroups;

    private Ec2InstanceAttributes(BuilderImpl builder) {
        this.ec2KeyName = builder.ec2KeyName;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.requestedEc2SubnetIds = builder.requestedEc2SubnetIds;
        this.ec2AvailabilityZone = builder.ec2AvailabilityZone;
        this.requestedEc2AvailabilityZones = builder.requestedEc2AvailabilityZones;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
        this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
        this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public List<String> requestedEc2SubnetIds() {
        return this.requestedEc2SubnetIds;
    }

    public String ec2AvailabilityZone() {
        return this.ec2AvailabilityZone;
    }

    public List<String> requestedEc2AvailabilityZones() {
        return this.requestedEc2AvailabilityZones;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String emrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public String emrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public String serviceAccessSecurityGroup() {
        return this.serviceAccessSecurityGroup;
    }

    public List<String> additionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups;
    }

    public List<String> additionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ec2KeyName() == null ? 0 : this.ec2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.ec2SubnetId() == null ? 0 : this.ec2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.requestedEc2SubnetIds() == null ? 0 : this.requestedEc2SubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.ec2AvailabilityZone() == null ? 0 : this.ec2AvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.requestedEc2AvailabilityZones() == null ? 0 : this.requestedEc2AvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.emrManagedMasterSecurityGroup() == null ? 0 : this.emrManagedMasterSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.emrManagedSlaveSecurityGroup() == null ? 0 : this.emrManagedSlaveSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.serviceAccessSecurityGroup() == null ? 0 : this.serviceAccessSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.additionalMasterSecurityGroups() == null ? 0 : this.additionalMasterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.additionalSlaveSecurityGroups() == null ? 0 : this.additionalSlaveSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAttributes)) {
            return false;
        }
        Ec2InstanceAttributes other = (Ec2InstanceAttributes)obj;
        if (other.ec2KeyName() == null ^ this.ec2KeyName() == null) {
            return false;
        }
        if (other.ec2KeyName() != null && !other.ec2KeyName().equals(this.ec2KeyName())) {
            return false;
        }
        if (other.ec2SubnetId() == null ^ this.ec2SubnetId() == null) {
            return false;
        }
        if (other.ec2SubnetId() != null && !other.ec2SubnetId().equals(this.ec2SubnetId())) {
            return false;
        }
        if (other.requestedEc2SubnetIds() == null ^ this.requestedEc2SubnetIds() == null) {
            return false;
        }
        if (other.requestedEc2SubnetIds() != null && !other.requestedEc2SubnetIds().equals(this.requestedEc2SubnetIds())) {
            return false;
        }
        if (other.ec2AvailabilityZone() == null ^ this.ec2AvailabilityZone() == null) {
            return false;
        }
        if (other.ec2AvailabilityZone() != null && !other.ec2AvailabilityZone().equals(this.ec2AvailabilityZone())) {
            return false;
        }
        if (other.requestedEc2AvailabilityZones() == null ^ this.requestedEc2AvailabilityZones() == null) {
            return false;
        }
        if (other.requestedEc2AvailabilityZones() != null && !other.requestedEc2AvailabilityZones().equals(this.requestedEc2AvailabilityZones())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.emrManagedMasterSecurityGroup() == null ^ this.emrManagedMasterSecurityGroup() == null) {
            return false;
        }
        if (other.emrManagedMasterSecurityGroup() != null && !other.emrManagedMasterSecurityGroup().equals(this.emrManagedMasterSecurityGroup())) {
            return false;
        }
        if (other.emrManagedSlaveSecurityGroup() == null ^ this.emrManagedSlaveSecurityGroup() == null) {
            return false;
        }
        if (other.emrManagedSlaveSecurityGroup() != null && !other.emrManagedSlaveSecurityGroup().equals(this.emrManagedSlaveSecurityGroup())) {
            return false;
        }
        if (other.serviceAccessSecurityGroup() == null ^ this.serviceAccessSecurityGroup() == null) {
            return false;
        }
        if (other.serviceAccessSecurityGroup() != null && !other.serviceAccessSecurityGroup().equals(this.serviceAccessSecurityGroup())) {
            return false;
        }
        if (other.additionalMasterSecurityGroups() == null ^ this.additionalMasterSecurityGroups() == null) {
            return false;
        }
        if (other.additionalMasterSecurityGroups() != null && !other.additionalMasterSecurityGroups().equals(this.additionalMasterSecurityGroups())) {
            return false;
        }
        if (other.additionalSlaveSecurityGroups() == null ^ this.additionalSlaveSecurityGroups() == null) {
            return false;
        }
        return other.additionalSlaveSecurityGroups() == null || other.additionalSlaveSecurityGroups().equals(this.additionalSlaveSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ec2KeyName() != null) {
            sb.append("Ec2KeyName: ").append(this.ec2KeyName()).append(",");
        }
        if (this.ec2SubnetId() != null) {
            sb.append("Ec2SubnetId: ").append(this.ec2SubnetId()).append(",");
        }
        if (this.requestedEc2SubnetIds() != null) {
            sb.append("RequestedEc2SubnetIds: ").append(this.requestedEc2SubnetIds()).append(",");
        }
        if (this.ec2AvailabilityZone() != null) {
            sb.append("Ec2AvailabilityZone: ").append(this.ec2AvailabilityZone()).append(",");
        }
        if (this.requestedEc2AvailabilityZones() != null) {
            sb.append("RequestedEc2AvailabilityZones: ").append(this.requestedEc2AvailabilityZones()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.emrManagedMasterSecurityGroup() != null) {
            sb.append("EmrManagedMasterSecurityGroup: ").append(this.emrManagedMasterSecurityGroup()).append(",");
        }
        if (this.emrManagedSlaveSecurityGroup() != null) {
            sb.append("EmrManagedSlaveSecurityGroup: ").append(this.emrManagedSlaveSecurityGroup()).append(",");
        }
        if (this.serviceAccessSecurityGroup() != null) {
            sb.append("ServiceAccessSecurityGroup: ").append(this.serviceAccessSecurityGroup()).append(",");
        }
        if (this.additionalMasterSecurityGroups() != null) {
            sb.append("AdditionalMasterSecurityGroups: ").append(this.additionalMasterSecurityGroups()).append(",");
        }
        if (this.additionalSlaveSecurityGroups() != null) {
            sb.append("AdditionalSlaveSecurityGroups: ").append(this.additionalSlaveSecurityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ec2InstanceAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String ec2KeyName;
        private String ec2SubnetId;
        private List<String> requestedEc2SubnetIds;
        private String ec2AvailabilityZone;
        private List<String> requestedEc2AvailabilityZones;
        private String iamInstanceProfile;
        private String emrManagedMasterSecurityGroup;
        private String emrManagedSlaveSecurityGroup;
        private String serviceAccessSecurityGroup;
        private List<String> additionalMasterSecurityGroups;
        private List<String> additionalSlaveSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAttributes model) {
            this.setEc2KeyName(model.ec2KeyName);
            this.setEc2SubnetId(model.ec2SubnetId);
            this.setRequestedEc2SubnetIds(model.requestedEc2SubnetIds);
            this.setEc2AvailabilityZone(model.ec2AvailabilityZone);
            this.setRequestedEc2AvailabilityZones(model.requestedEc2AvailabilityZones);
            this.setIamInstanceProfile(model.iamInstanceProfile);
            this.setEmrManagedMasterSecurityGroup(model.emrManagedMasterSecurityGroup);
            this.setEmrManagedSlaveSecurityGroup(model.emrManagedSlaveSecurityGroup);
            this.setServiceAccessSecurityGroup(model.serviceAccessSecurityGroup);
            this.setAdditionalMasterSecurityGroups(model.additionalMasterSecurityGroups);
            this.setAdditionalSlaveSecurityGroups(model.additionalSlaveSecurityGroups);
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final Collection<String> getRequestedEc2SubnetIds() {
            return this.requestedEc2SubnetIds;
        }

        @Override
        public final Builder requestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2SubnetIds(String ... requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds(Arrays.asList(requestedEc2SubnetIds));
            return this;
        }

        public final void setRequestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
        }

        public final String getEc2AvailabilityZone() {
            return this.ec2AvailabilityZone;
        }

        @Override
        public final Builder ec2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
            return this;
        }

        public final void setEc2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
        }

        public final Collection<String> getRequestedEc2AvailabilityZones() {
            return this.requestedEc2AvailabilityZones;
        }

        @Override
        public final Builder requestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2AvailabilityZones(String ... requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones(Arrays.asList(requestedEc2AvailabilityZones));
            return this;
        }

        public final void setRequestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getEmrManagedMasterSecurityGroup() {
            return this.emrManagedMasterSecurityGroup;
        }

        @Override
        public final Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        public final void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
        }

        public final String getEmrManagedSlaveSecurityGroup() {
            return this.emrManagedSlaveSecurityGroup;
        }

        @Override
        public final Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        public final void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
        }

        public final String getServiceAccessSecurityGroup() {
            return this.serviceAccessSecurityGroup;
        }

        @Override
        public final Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        public final void setServiceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
        }

        public final Collection<String> getAdditionalMasterSecurityGroups() {
            return this.additionalMasterSecurityGroups;
        }

        @Override
        public final Builder additionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups(Arrays.asList(additionalMasterSecurityGroups));
            return this;
        }

        public final void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
        }

        public final Collection<String> getAdditionalSlaveSecurityGroups() {
            return this.additionalSlaveSecurityGroups;
        }

        @Override
        public final Builder additionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups(Arrays.asList(additionalSlaveSecurityGroups));
            return this;
        }

        public final void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
        }

        public Ec2InstanceAttributes build() {
            return new Ec2InstanceAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ec2InstanceAttributes> {
        public Builder ec2KeyName(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder requestedEc2SubnetIds(Collection<String> var1);

        public Builder requestedEc2SubnetIds(String ... var1);

        public Builder ec2AvailabilityZone(String var1);

        public Builder requestedEc2AvailabilityZones(Collection<String> var1);

        public Builder requestedEc2AvailabilityZones(String ... var1);

        public Builder iamInstanceProfile(String var1);

        public Builder emrManagedMasterSecurityGroup(String var1);

        public Builder emrManagedSlaveSecurityGroup(String var1);

        public Builder serviceAccessSecurityGroup(String var1);

        public Builder additionalMasterSecurityGroups(Collection<String> var1);

        public Builder additionalMasterSecurityGroups(String ... var1);

        public Builder additionalSlaveSecurityGroups(Collection<String> var1);

        public Builder additionalSlaveSecurityGroups(String ... var1);
    }
}

