/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.EbsVolume;

@SdkInternalApi
public class EbsVolumeMarshaller {
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").build();
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").build();
    private static final EbsVolumeMarshaller INSTANCE = new EbsVolumeMarshaller();

    public static EbsVolumeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EbsVolume ebsVolume, ProtocolMarshaller protocolMarshaller) {
        if (ebsVolume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ebsVolume.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)ebsVolume.volumeId(), VOLUMEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

