/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsBlockDevice;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceListCopier;
import software.amazon.awssdk.services.emr.model.InstanceGroupStatus;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.model.ShrinkPolicy;
import software.amazon.awssdk.services.emr.transform.InstanceGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroup> {
    private final String id;
    private final String name;
    private final String market;
    private final String instanceGroupType;
    private final String bidPrice;
    private final String instanceType;
    private final Integer requestedInstanceCount;
    private final Integer runningInstanceCount;
    private final InstanceGroupStatus status;
    private final List<Configuration> configurations;
    private final List<EbsBlockDevice> ebsBlockDevices;
    private final Boolean ebsOptimized;
    private final ShrinkPolicy shrinkPolicy;
    private final AutoScalingPolicyDescription autoScalingPolicy;

    private InstanceGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.market = builder.market;
        this.instanceGroupType = builder.instanceGroupType;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.requestedInstanceCount = builder.requestedInstanceCount;
        this.runningInstanceCount = builder.runningInstanceCount;
        this.status = builder.status;
        this.configurations = builder.configurations;
        this.ebsBlockDevices = builder.ebsBlockDevices;
        this.ebsOptimized = builder.ebsOptimized;
        this.shrinkPolicy = builder.shrinkPolicy;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String market() {
        return this.market;
    }

    public String instanceGroupType() {
        return this.instanceGroupType;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer requestedInstanceCount() {
        return this.requestedInstanceCount;
    }

    public Integer runningInstanceCount() {
        return this.runningInstanceCount;
    }

    public InstanceGroupStatus status() {
        return this.status;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public List<EbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public ShrinkPolicy shrinkPolicy() {
        return this.shrinkPolicy;
    }

    public AutoScalingPolicyDescription autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.market() == null ? 0 : this.market().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroupType() == null ? 0 : this.instanceGroupType().hashCode());
        hashCode = 31 * hashCode + (this.bidPrice() == null ? 0 : this.bidPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.requestedInstanceCount() == null ? 0 : this.requestedInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.runningInstanceCount() == null ? 0 : this.runningInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.ebsBlockDevices() == null ? 0 : this.ebsBlockDevices().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.shrinkPolicy() == null ? 0 : this.shrinkPolicy().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingPolicy() == null ? 0 : this.autoScalingPolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroup)) {
            return false;
        }
        InstanceGroup other = (InstanceGroup)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.market() == null ^ this.market() == null) {
            return false;
        }
        if (other.market() != null && !other.market().equals(this.market())) {
            return false;
        }
        if (other.instanceGroupType() == null ^ this.instanceGroupType() == null) {
            return false;
        }
        if (other.instanceGroupType() != null && !other.instanceGroupType().equals(this.instanceGroupType())) {
            return false;
        }
        if (other.bidPrice() == null ^ this.bidPrice() == null) {
            return false;
        }
        if (other.bidPrice() != null && !other.bidPrice().equals(this.bidPrice())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.requestedInstanceCount() == null ^ this.requestedInstanceCount() == null) {
            return false;
        }
        if (other.requestedInstanceCount() != null && !other.requestedInstanceCount().equals(this.requestedInstanceCount())) {
            return false;
        }
        if (other.runningInstanceCount() == null ^ this.runningInstanceCount() == null) {
            return false;
        }
        if (other.runningInstanceCount() != null && !other.runningInstanceCount().equals(this.runningInstanceCount())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.ebsBlockDevices() == null ^ this.ebsBlockDevices() == null) {
            return false;
        }
        if (other.ebsBlockDevices() != null && !other.ebsBlockDevices().equals(this.ebsBlockDevices())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.shrinkPolicy() == null ^ this.shrinkPolicy() == null) {
            return false;
        }
        if (other.shrinkPolicy() != null && !other.shrinkPolicy().equals(this.shrinkPolicy())) {
            return false;
        }
        if (other.autoScalingPolicy() == null ^ this.autoScalingPolicy() == null) {
            return false;
        }
        return other.autoScalingPolicy() == null || other.autoScalingPolicy().equals(this.autoScalingPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.market() != null) {
            sb.append("Market: ").append(this.market()).append(",");
        }
        if (this.instanceGroupType() != null) {
            sb.append("InstanceGroupType: ").append(this.instanceGroupType()).append(",");
        }
        if (this.bidPrice() != null) {
            sb.append("BidPrice: ").append(this.bidPrice()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.requestedInstanceCount() != null) {
            sb.append("RequestedInstanceCount: ").append(this.requestedInstanceCount()).append(",");
        }
        if (this.runningInstanceCount() != null) {
            sb.append("RunningInstanceCount: ").append(this.runningInstanceCount()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.ebsBlockDevices() != null) {
            sb.append("EbsBlockDevices: ").append(this.ebsBlockDevices()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.shrinkPolicy() != null) {
            sb.append("ShrinkPolicy: ").append(this.shrinkPolicy()).append(",");
        }
        if (this.autoScalingPolicy() != null) {
            sb.append("AutoScalingPolicy: ").append(this.autoScalingPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String market;
        private String instanceGroupType;
        private String bidPrice;
        private String instanceType;
        private Integer requestedInstanceCount;
        private Integer runningInstanceCount;
        private InstanceGroupStatus status;
        private List<Configuration> configurations;
        private List<EbsBlockDevice> ebsBlockDevices;
        private Boolean ebsOptimized;
        private ShrinkPolicy shrinkPolicy;
        private AutoScalingPolicyDescription autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroup model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setMarket(model.market);
            this.setInstanceGroupType(model.instanceGroupType);
            this.setBidPrice(model.bidPrice);
            this.setInstanceType(model.instanceType);
            this.setRequestedInstanceCount(model.requestedInstanceCount);
            this.setRunningInstanceCount(model.runningInstanceCount);
            this.setStatus(model.status);
            this.setConfigurations(model.configurations);
            this.setEbsBlockDevices(model.ebsBlockDevices);
            this.setEbsOptimized(model.ebsOptimized);
            this.setShrinkPolicy(model.shrinkPolicy);
            this.setAutoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceGroupType() {
            return this.instanceGroupType;
        }

        @Override
        public final Builder instanceGroupType(String instanceGroupType) {
            this.instanceGroupType = instanceGroupType;
            return this;
        }

        @Override
        public final Builder instanceGroupType(InstanceGroupType instanceGroupType) {
            this.instanceGroupType(instanceGroupType.toString());
            return this;
        }

        public final void setInstanceGroupType(String instanceGroupType) {
            this.instanceGroupType = instanceGroupType;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getRequestedInstanceCount() {
            return this.requestedInstanceCount;
        }

        @Override
        public final Builder requestedInstanceCount(Integer requestedInstanceCount) {
            this.requestedInstanceCount = requestedInstanceCount;
            return this;
        }

        public final void setRequestedInstanceCount(Integer requestedInstanceCount) {
            this.requestedInstanceCount = requestedInstanceCount;
        }

        public final Integer getRunningInstanceCount() {
            return this.runningInstanceCount;
        }

        @Override
        public final Builder runningInstanceCount(Integer runningInstanceCount) {
            this.runningInstanceCount = runningInstanceCount;
            return this;
        }

        public final void setRunningInstanceCount(Integer runningInstanceCount) {
            this.runningInstanceCount = runningInstanceCount;
        }

        public final InstanceGroupStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(InstanceGroupStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceGroupStatus status) {
            this.status = status;
        }

        public final Collection<Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
        }

        public final Collection<EbsBlockDevice> getEbsBlockDevices() {
            return this.ebsBlockDevices;
        }

        @Override
        public final Builder ebsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copy(ebsBlockDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDevices(EbsBlockDevice ... ebsBlockDevices) {
            this.ebsBlockDevices(Arrays.asList(ebsBlockDevices));
            return this;
        }

        public final void setEbsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copy(ebsBlockDevices);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ShrinkPolicy getShrinkPolicy() {
            return this.shrinkPolicy;
        }

        @Override
        public final Builder shrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
            return this;
        }

        public final void setShrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
        }

        public final AutoScalingPolicyDescription getAutoScalingPolicy() {
            return this.autoScalingPolicy;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
        }

        public InstanceGroup build() {
            return new InstanceGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroup> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceGroupType(String var1);

        public Builder instanceGroupType(InstanceGroupType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder requestedInstanceCount(Integer var1);

        public Builder runningInstanceCount(Integer var1);

        public Builder status(InstanceGroupStatus var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder ebsBlockDevices(Collection<EbsBlockDevice> var1);

        public Builder ebsBlockDevices(EbsBlockDevice ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder shrinkPolicy(ShrinkPolicy var1);

        public Builder autoScalingPolicy(AutoScalingPolicyDescription var1);
    }
}

