/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.services.emr.model.ApplicationListCopier;
import software.amazon.awssdk.services.emr.model.ClusterStatus;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes;
import software.amazon.awssdk.services.emr.model.InstanceCollectionType;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.services.emr.transform.ClusterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements StructuredPojo,
ToCopyableBuilder<Builder, Cluster> {
    private final String id;
    private final String name;
    private final ClusterStatus status;
    private final Ec2InstanceAttributes ec2InstanceAttributes;
    private final String instanceCollectionType;
    private final String logUri;
    private final String requestedAmiVersion;
    private final String runningAmiVersion;
    private final String releaseLabel;
    private final Boolean autoTerminate;
    private final Boolean terminationProtected;
    private final Boolean visibleToAllUsers;
    private final List<Application> applications;
    private final List<Tag> tags;
    private final String serviceRole;
    private final Integer normalizedInstanceHours;
    private final String masterPublicDnsName;
    private final List<Configuration> configurations;
    private final String securityConfiguration;
    private final String autoScalingRole;
    private final String scaleDownBehavior;

    private Cluster(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.ec2InstanceAttributes = builder.ec2InstanceAttributes;
        this.instanceCollectionType = builder.instanceCollectionType;
        this.logUri = builder.logUri;
        this.requestedAmiVersion = builder.requestedAmiVersion;
        this.runningAmiVersion = builder.runningAmiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.autoTerminate = builder.autoTerminate;
        this.terminationProtected = builder.terminationProtected;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.applications = builder.applications;
        this.tags = builder.tags;
        this.serviceRole = builder.serviceRole;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.masterPublicDnsName = builder.masterPublicDnsName;
        this.configurations = builder.configurations;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ClusterStatus status() {
        return this.status;
    }

    public Ec2InstanceAttributes ec2InstanceAttributes() {
        return this.ec2InstanceAttributes;
    }

    public String instanceCollectionType() {
        return this.instanceCollectionType;
    }

    public String logUri() {
        return this.logUri;
    }

    public String requestedAmiVersion() {
        return this.requestedAmiVersion;
    }

    public String runningAmiVersion() {
        return this.runningAmiVersion;
    }

    public String releaseLabel() {
        return this.releaseLabel;
    }

    public Boolean autoTerminate() {
        return this.autoTerminate;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public String masterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public String autoScalingRole() {
        return this.autoScalingRole;
    }

    public String scaleDownBehavior() {
        return this.scaleDownBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceAttributes() == null ? 0 : this.ec2InstanceAttributes().hashCode());
        hashCode = 31 * hashCode + (this.instanceCollectionType() == null ? 0 : this.instanceCollectionType().hashCode());
        hashCode = 31 * hashCode + (this.logUri() == null ? 0 : this.logUri().hashCode());
        hashCode = 31 * hashCode + (this.requestedAmiVersion() == null ? 0 : this.requestedAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.runningAmiVersion() == null ? 0 : this.runningAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.releaseLabel() == null ? 0 : this.releaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.autoTerminate() == null ? 0 : this.autoTerminate().hashCode());
        hashCode = 31 * hashCode + (this.terminationProtected() == null ? 0 : this.terminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.visibleToAllUsers() == null ? 0 : this.visibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.applications() == null ? 0 : this.applications().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.normalizedInstanceHours() == null ? 0 : this.normalizedInstanceHours().hashCode());
        hashCode = 31 * hashCode + (this.masterPublicDnsName() == null ? 0 : this.masterPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.securityConfiguration() == null ? 0 : this.securityConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingRole() == null ? 0 : this.autoScalingRole().hashCode());
        hashCode = 31 * hashCode + (this.scaleDownBehavior() == null ? 0 : this.scaleDownBehavior().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.ec2InstanceAttributes() == null ^ this.ec2InstanceAttributes() == null) {
            return false;
        }
        if (other.ec2InstanceAttributes() != null && !other.ec2InstanceAttributes().equals(this.ec2InstanceAttributes())) {
            return false;
        }
        if (other.instanceCollectionType() == null ^ this.instanceCollectionType() == null) {
            return false;
        }
        if (other.instanceCollectionType() != null && !other.instanceCollectionType().equals(this.instanceCollectionType())) {
            return false;
        }
        if (other.logUri() == null ^ this.logUri() == null) {
            return false;
        }
        if (other.logUri() != null && !other.logUri().equals(this.logUri())) {
            return false;
        }
        if (other.requestedAmiVersion() == null ^ this.requestedAmiVersion() == null) {
            return false;
        }
        if (other.requestedAmiVersion() != null && !other.requestedAmiVersion().equals(this.requestedAmiVersion())) {
            return false;
        }
        if (other.runningAmiVersion() == null ^ this.runningAmiVersion() == null) {
            return false;
        }
        if (other.runningAmiVersion() != null && !other.runningAmiVersion().equals(this.runningAmiVersion())) {
            return false;
        }
        if (other.releaseLabel() == null ^ this.releaseLabel() == null) {
            return false;
        }
        if (other.releaseLabel() != null && !other.releaseLabel().equals(this.releaseLabel())) {
            return false;
        }
        if (other.autoTerminate() == null ^ this.autoTerminate() == null) {
            return false;
        }
        if (other.autoTerminate() != null && !other.autoTerminate().equals(this.autoTerminate())) {
            return false;
        }
        if (other.terminationProtected() == null ^ this.terminationProtected() == null) {
            return false;
        }
        if (other.terminationProtected() != null && !other.terminationProtected().equals(this.terminationProtected())) {
            return false;
        }
        if (other.visibleToAllUsers() == null ^ this.visibleToAllUsers() == null) {
            return false;
        }
        if (other.visibleToAllUsers() != null && !other.visibleToAllUsers().equals(this.visibleToAllUsers())) {
            return false;
        }
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        if (other.applications() != null && !other.applications().equals(this.applications())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.normalizedInstanceHours() == null ^ this.normalizedInstanceHours() == null) {
            return false;
        }
        if (other.normalizedInstanceHours() != null && !other.normalizedInstanceHours().equals(this.normalizedInstanceHours())) {
            return false;
        }
        if (other.masterPublicDnsName() == null ^ this.masterPublicDnsName() == null) {
            return false;
        }
        if (other.masterPublicDnsName() != null && !other.masterPublicDnsName().equals(this.masterPublicDnsName())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.securityConfiguration() == null ^ this.securityConfiguration() == null) {
            return false;
        }
        if (other.securityConfiguration() != null && !other.securityConfiguration().equals(this.securityConfiguration())) {
            return false;
        }
        if (other.autoScalingRole() == null ^ this.autoScalingRole() == null) {
            return false;
        }
        if (other.autoScalingRole() != null && !other.autoScalingRole().equals(this.autoScalingRole())) {
            return false;
        }
        if (other.scaleDownBehavior() == null ^ this.scaleDownBehavior() == null) {
            return false;
        }
        return other.scaleDownBehavior() == null || other.scaleDownBehavior().equals(this.scaleDownBehavior());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.ec2InstanceAttributes() != null) {
            sb.append("Ec2InstanceAttributes: ").append(this.ec2InstanceAttributes()).append(",");
        }
        if (this.instanceCollectionType() != null) {
            sb.append("InstanceCollectionType: ").append(this.instanceCollectionType()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.requestedAmiVersion() != null) {
            sb.append("RequestedAmiVersion: ").append(this.requestedAmiVersion()).append(",");
        }
        if (this.runningAmiVersion() != null) {
            sb.append("RunningAmiVersion: ").append(this.runningAmiVersion()).append(",");
        }
        if (this.releaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.releaseLabel()).append(",");
        }
        if (this.autoTerminate() != null) {
            sb.append("AutoTerminate: ").append(this.autoTerminate()).append(",");
        }
        if (this.terminationProtected() != null) {
            sb.append("TerminationProtected: ").append(this.terminationProtected()).append(",");
        }
        if (this.visibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: ").append(this.visibleToAllUsers()).append(",");
        }
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.normalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: ").append(this.normalizedInstanceHours()).append(",");
        }
        if (this.masterPublicDnsName() != null) {
            sb.append("MasterPublicDnsName: ").append(this.masterPublicDnsName()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.securityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.securityConfiguration()).append(",");
        }
        if (this.autoScalingRole() != null) {
            sb.append("AutoScalingRole: ").append(this.autoScalingRole()).append(",");
        }
        if (this.scaleDownBehavior() != null) {
            sb.append("ScaleDownBehavior: ").append(this.scaleDownBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ClusterStatus status;
        private Ec2InstanceAttributes ec2InstanceAttributes;
        private String instanceCollectionType;
        private String logUri;
        private String requestedAmiVersion;
        private String runningAmiVersion;
        private String releaseLabel;
        private Boolean autoTerminate;
        private Boolean terminationProtected;
        private Boolean visibleToAllUsers;
        private List<Application> applications;
        private List<Tag> tags;
        private String serviceRole;
        private Integer normalizedInstanceHours;
        private String masterPublicDnsName;
        private List<Configuration> configurations;
        private String securityConfiguration;
        private String autoScalingRole;
        private String scaleDownBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setStatus(model.status);
            this.setEc2InstanceAttributes(model.ec2InstanceAttributes);
            this.setInstanceCollectionType(model.instanceCollectionType);
            this.setLogUri(model.logUri);
            this.setRequestedAmiVersion(model.requestedAmiVersion);
            this.setRunningAmiVersion(model.runningAmiVersion);
            this.setReleaseLabel(model.releaseLabel);
            this.setAutoTerminate(model.autoTerminate);
            this.setTerminationProtected(model.terminationProtected);
            this.setVisibleToAllUsers(model.visibleToAllUsers);
            this.setApplications(model.applications);
            this.setTags(model.tags);
            this.setServiceRole(model.serviceRole);
            this.setNormalizedInstanceHours(model.normalizedInstanceHours);
            this.setMasterPublicDnsName(model.masterPublicDnsName);
            this.setConfigurations(model.configurations);
            this.setSecurityConfiguration(model.securityConfiguration);
            this.setAutoScalingRole(model.autoScalingRole);
            this.setScaleDownBehavior(model.scaleDownBehavior);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ClusterStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClusterStatus status) {
            this.status = status;
        }

        public final Ec2InstanceAttributes getEc2InstanceAttributes() {
            return this.ec2InstanceAttributes;
        }

        @Override
        public final Builder ec2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes;
            return this;
        }

        public final void setEc2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes;
        }

        public final String getInstanceCollectionType() {
            return this.instanceCollectionType;
        }

        @Override
        public final Builder instanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
            return this;
        }

        @Override
        public final Builder instanceCollectionType(InstanceCollectionType instanceCollectionType) {
            this.instanceCollectionType(instanceCollectionType.toString());
            return this;
        }

        public final void setInstanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getRequestedAmiVersion() {
            return this.requestedAmiVersion;
        }

        @Override
        public final Builder requestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
            return this;
        }

        public final void setRequestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
        }

        public final String getRunningAmiVersion() {
            return this.runningAmiVersion;
        }

        @Override
        public final Builder runningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
            return this;
        }

        public final void setRunningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final Boolean getAutoTerminate() {
            return this.autoTerminate;
        }

        @Override
        public final Builder autoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
            return this;
        }

        public final void setAutoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final Collection<Application> getApplications() {
            return this.applications;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public final String getMasterPublicDnsName() {
            return this.masterPublicDnsName;
        }

        @Override
        public final Builder masterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
            return this;
        }

        public final void setMasterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
        }

        public final Collection<Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(ClusterStatus var1);

        public Builder ec2InstanceAttributes(Ec2InstanceAttributes var1);

        public Builder instanceCollectionType(String var1);

        public Builder instanceCollectionType(InstanceCollectionType var1);

        public Builder logUri(String var1);

        public Builder requestedAmiVersion(String var1);

        public Builder runningAmiVersion(String var1);

        public Builder releaseLabel(String var1);

        public Builder autoTerminate(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder serviceRole(String var1);

        public Builder normalizedInstanceHours(Integer var1);

        public Builder masterPublicDnsName(String var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder securityConfiguration(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);
    }
}

