/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScalingAction;

@SdkInternalApi
public class ScalingActionMarshaller {
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").build();
    private static final MarshallingInfo<StructuredPojo> SIMPLESCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimpleScalingPolicyConfiguration").build();
    private static final ScalingActionMarshaller instance = new ScalingActionMarshaller();

    public static ScalingActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScalingAction scalingAction, ProtocolMarshaller protocolMarshaller) {
        if (scalingAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalingAction.market(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)scalingAction.simpleScalingPolicyConfiguration(), SIMPLESCALINGPOLICYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

