/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.Configuration;

public class ConfigurationUnmarshaller
implements Unmarshaller<Configuration, JsonUnmarshallerContext> {
    private static ConfigurationUnmarshaller INSTANCE;

    public Configuration unmarshall(JsonUnmarshallerContext context) throws Exception {
        Configuration.Builder configurationBuilder = Configuration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Classification", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.classification((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.configurations(new ListUnmarshaller((Unmarshaller)ConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Properties", targetDepth)) {
                    context.nextToken();
                    configurationBuilder.properties(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Configuration)configurationBuilder.build();
    }

    public static ConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

