/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstanceGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
    private final String clusterId;
    private final List<InstanceGroupModifyConfig> instanceGroups;

    private ModifyInstanceGroupsRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.instanceGroups = builder.instanceGroups;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<InstanceGroupModifyConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroups() == null ? 0 : this.instanceGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest)((Object)obj);
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.instanceGroups() == null ^ this.instanceGroups() == null) {
            return false;
        }
        return other.instanceGroups() == null || other.instanceGroups().equals(this.instanceGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private List<InstanceGroupModifyConfig> instanceGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceGroupsRequest model) {
            this.setClusterId(model.clusterId);
            this.setInstanceGroups(model.instanceGroups);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<InstanceGroupModifyConfig> getInstanceGroups() {
            return this.instanceGroups;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copy(instanceGroups);
        }

        @SafeVarargs
        public final void setInstanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
        }

        public ModifyInstanceGroupsRequest build() {
            return new ModifyInstanceGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroups(Collection<InstanceGroupModifyConfig> var1);

        public Builder instanceGroups(InstanceGroupModifyConfig ... var1);
    }
}

