/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EbsVolume;
import software.amazon.awssdk.services.emr.model.EbsVolumeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceStatus;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String id;
    private final String ec2InstanceId;
    private final String publicDnsName;
    private final String publicIpAddress;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final InstanceStatus status;
    private final String instanceGroupId;
    private final String instanceFleetId;
    private final String market;
    private final String instanceType;
    private final List<EbsVolume> ebsVolumes;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.status = builder.status;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceFleetId = builder.instanceFleetId;
        this.market = builder.market;
        this.instanceType = builder.instanceType;
        this.ebsVolumes = builder.ebsVolumes;
    }

    public String id() {
        return this.id;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public InstanceStatus status() {
        return this.status;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public String market() {
        return this.market;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public List<EbsVolume> ebsVolumes() {
        return this.ebsVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.ec2InstanceId() == null ? 0 : this.ec2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.publicDnsName() == null ? 0 : this.publicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.publicIpAddress() == null ? 0 : this.publicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.privateDnsName() == null ? 0 : this.privateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroupId() == null ? 0 : this.instanceGroupId().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleetId() == null ? 0 : this.instanceFleetId().hashCode());
        hashCode = 31 * hashCode + (this.market() == null ? 0 : this.market().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.ebsVolumes() == null ? 0 : this.ebsVolumes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.ec2InstanceId() == null ^ this.ec2InstanceId() == null) {
            return false;
        }
        if (other.ec2InstanceId() != null && !other.ec2InstanceId().equals(this.ec2InstanceId())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIpAddress() == null ^ this.publicIpAddress() == null) {
            return false;
        }
        if (other.publicIpAddress() != null && !other.publicIpAddress().equals(this.publicIpAddress())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.instanceGroupId() == null ^ this.instanceGroupId() == null) {
            return false;
        }
        if (other.instanceGroupId() != null && !other.instanceGroupId().equals(this.instanceGroupId())) {
            return false;
        }
        if (other.instanceFleetId() == null ^ this.instanceFleetId() == null) {
            return false;
        }
        if (other.instanceFleetId() != null && !other.instanceFleetId().equals(this.instanceFleetId())) {
            return false;
        }
        if (other.market() == null ^ this.market() == null) {
            return false;
        }
        if (other.market() != null && !other.market().equals(this.market())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.ebsVolumes() == null ^ this.ebsVolumes() == null) {
            return false;
        }
        return other.ebsVolumes() == null || other.ebsVolumes().equals(this.ebsVolumes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.ec2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(this.ec2InstanceId()).append(",");
        }
        if (this.publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.publicDnsName()).append(",");
        }
        if (this.publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(this.publicIpAddress()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.instanceGroupId() != null) {
            sb.append("InstanceGroupId: ").append(this.instanceGroupId()).append(",");
        }
        if (this.instanceFleetId() != null) {
            sb.append("InstanceFleetId: ").append(this.instanceFleetId()).append(",");
        }
        if (this.market() != null) {
            sb.append("Market: ").append(this.market()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.ebsVolumes() != null) {
            sb.append("EbsVolumes: ").append(this.ebsVolumes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String ec2InstanceId;
        private String publicDnsName;
        private String publicIpAddress;
        private String privateDnsName;
        private String privateIpAddress;
        private InstanceStatus status;
        private String instanceGroupId;
        private String instanceFleetId;
        private String market;
        private String instanceType;
        private List<EbsVolume> ebsVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.setId(model.id);
            this.setEc2InstanceId(model.ec2InstanceId);
            this.setPublicDnsName(model.publicDnsName);
            this.setPublicIpAddress(model.publicIpAddress);
            this.setPrivateDnsName(model.privateDnsName);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setStatus(model.status);
            this.setInstanceGroupId(model.instanceGroupId);
            this.setInstanceFleetId(model.instanceFleetId);
            this.setMarket(model.market);
            this.setInstanceType(model.instanceType);
            this.setEbsVolumes(model.ebsVolumes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final InstanceStatus getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceStatus status) {
            this.status = status;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final void setMarket(MarketType market) {
            this.market(market.toString());
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Collection<EbsVolume> getEbsVolumes() {
            return this.ebsVolumes;
        }

        @Override
        public final Builder ebsVolumes(Collection<EbsVolume> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copy(ebsVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsVolumes(EbsVolume ... ebsVolumes) {
            this.ebsVolumes(Arrays.asList(ebsVolumes));
            return this;
        }

        public final void setEbsVolumes(Collection<EbsVolume> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copy(ebsVolumes);
        }

        @SafeVarargs
        public final void setEbsVolumes(EbsVolume ... ebsVolumes) {
            this.ebsVolumes(Arrays.asList(ebsVolumes));
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder id(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIpAddress(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder status(InstanceStatus var1);

        public Builder instanceGroupId(String var1);

        public Builder instanceFleetId(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceType(String var1);

        public Builder ebsVolumes(Collection<EbsVolume> var1);

        public Builder ebsVolumes(EbsVolume ... var1);
    }
}

