/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.StepExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepExecutionStatusDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepExecutionStatusDetail> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StepExecutionStatusDetail.getter(StepExecutionStatusDetail::stateAsString)).setter(StepExecutionStatusDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StepExecutionStatusDetail.getter(StepExecutionStatusDetail::creationDateTime)).setter(StepExecutionStatusDetail.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StepExecutionStatusDetail.getter(StepExecutionStatusDetail::startDateTime)).setter(StepExecutionStatusDetail.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StepExecutionStatusDetail.getter(StepExecutionStatusDetail::endDateTime)).setter(StepExecutionStatusDetail.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()}).build();
    private static final SdkField<String> LAST_STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StepExecutionStatusDetail.getter(StepExecutionStatusDetail::lastStateChangeReason)).setter(StepExecutionStatusDetail.setter(Builder::lastStateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStateChangeReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, CREATION_DATE_TIME_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, LAST_STATE_CHANGE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final Instant creationDateTime;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final String lastStateChangeReason;

    private StepExecutionStatusDetail(BuilderImpl builder) {
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.lastStateChangeReason = builder.lastStateChangeReason;
    }

    public StepExecutionState state() {
        return StepExecutionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant startDateTime() {
        return this.startDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecutionStatusDetail)) {
            return false;
        }
        StepExecutionStatusDetail other = (StepExecutionStatusDetail)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.lastStateChangeReason(), other.lastStateChangeReason());
    }

    public String toString() {
        return ToString.builder((String)"StepExecutionStatusDetail").add("State", (Object)this.stateAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("LastStateChangeReason", (Object)this.lastStateChangeReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "LastStateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.lastStateChangeReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepExecutionStatusDetail, T> g) {
        return obj -> g.apply((StepExecutionStatusDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private Instant creationDateTime;
        private Instant startDateTime;
        private Instant endDateTime;
        private String lastStateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecutionStatusDetail model) {
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.lastStateChangeReason(model.lastStateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StepExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        public StepExecutionStatusDetail build() {
            return new StepExecutionStatusDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepExecutionStatusDetail> {
        public Builder state(String var1);

        public Builder state(StepExecutionState var1);

        public Builder creationDateTime(Instant var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder lastStateChangeReason(String var1);
    }
}

