/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.Step;
import software.amazon.awssdk.services.emr.transform.HadoopStepConfigUnmarshaller;
import software.amazon.awssdk.services.emr.transform.StepStatusUnmarshaller;

public class StepUnmarshaller
implements Unmarshaller<Step, JsonUnmarshallerContext> {
    private static final StepUnmarshaller INSTANCE = new StepUnmarshaller();

    public Step unmarshall(JsonUnmarshallerContext context) throws Exception {
        Step.Builder stepBuilder = Step.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    stepBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stepBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Config", targetDepth)) {
                    context.nextToken();
                    stepBuilder.config(HadoopStepConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ActionOnFailure", targetDepth)) {
                    context.nextToken();
                    stepBuilder.actionOnFailure((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    stepBuilder.status(StepStatusUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Step)stepBuilder.build();
    }

    public static StepUnmarshaller getInstance() {
        return INSTANCE;
    }
}

