/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepStatusMarshaller {
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMELINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeline").isBinary(false).build();
    private static final StepStatusMarshaller INSTANCE = new StepStatusMarshaller();

    private StepStatusMarshaller() {
    }

    public static StepStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepStatus stepStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepStatus, (String)"stepStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepStatus.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)stepStatus.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)stepStatus.failureDetails(), FAILUREDETAILS_BINDING);
            protocolMarshaller.marshall((Object)stepStatus.timeline(), TIMELINE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

