/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ScalingConstraints;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScalingConstraintsMarshaller {
    private static final MarshallingInfo<Integer> MINCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxCapacity").isBinary(false).build();
    private static final ScalingConstraintsMarshaller INSTANCE = new ScalingConstraintsMarshaller();

    private ScalingConstraintsMarshaller() {
    }

    public static ScalingConstraintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingConstraints scalingConstraints, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scalingConstraints, (String)"scalingConstraints");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scalingConstraints.minCapacity(), MINCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalingConstraints.maxCapacity(), MAXCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

