/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.KerberosAttributes;

public class KerberosAttributesUnmarshaller
implements Unmarshaller<KerberosAttributes, JsonUnmarshallerContext> {
    private static final KerberosAttributesUnmarshaller INSTANCE = new KerberosAttributesUnmarshaller();

    public KerberosAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        KerberosAttributes.Builder kerberosAttributesBuilder = KerberosAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Realm", targetDepth)) {
                    context.nextToken();
                    kerberosAttributesBuilder.realm((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KdcAdminPassword", targetDepth)) {
                    context.nextToken();
                    kerberosAttributesBuilder.kdcAdminPassword((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CrossRealmTrustPrincipalPassword", targetDepth)) {
                    context.nextToken();
                    kerberosAttributesBuilder.crossRealmTrustPrincipalPassword((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ADDomainJoinUser", targetDepth)) {
                    context.nextToken();
                    kerberosAttributesBuilder.adDomainJoinUser((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ADDomainJoinPassword", targetDepth)) {
                    context.nextToken();
                    kerberosAttributesBuilder.adDomainJoinPassword((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KerberosAttributes)kerberosAttributesBuilder.build();
    }

    public static KerberosAttributesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

