/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.KerberosAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KerberosAttributesMarshaller {
    private static final MarshallingInfo<String> REALM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Realm").isBinary(false).build();
    private static final MarshallingInfo<String> KDCADMINPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KdcAdminPassword").isBinary(false).build();
    private static final MarshallingInfo<String> CROSSREALMTRUSTPRINCIPALPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrossRealmTrustPrincipalPassword").isBinary(false).build();
    private static final MarshallingInfo<String> ADDOMAINJOINUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ADDomainJoinUser").isBinary(false).build();
    private static final MarshallingInfo<String> ADDOMAINJOINPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ADDomainJoinPassword").isBinary(false).build();
    private static final KerberosAttributesMarshaller INSTANCE = new KerberosAttributesMarshaller();

    private KerberosAttributesMarshaller() {
    }

    public static KerberosAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KerberosAttributes kerberosAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kerberosAttributes, (String)"kerberosAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kerberosAttributes.realm(), REALM_BINDING);
            protocolMarshaller.marshall((Object)kerberosAttributes.kdcAdminPassword(), KDCADMINPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)kerberosAttributes.crossRealmTrustPrincipalPassword(), CROSSREALMTRUSTPRINCIPALPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)kerberosAttributes.adDomainJoinUser(), ADDOMAINJOINUSER_BINDING);
            protocolMarshaller.marshall((Object)kerberosAttributes.adDomainJoinPassword(), ADDOMAINJOINPASSWORD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

