/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceGroupConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRole").isBinary(false).build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EBSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUTOSCALINGPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingPolicy").isBinary(false).build();
    private static final InstanceGroupConfigMarshaller INSTANCE = new InstanceGroupConfigMarshaller();

    private InstanceGroupConfigMarshaller() {
    }

    public static InstanceGroupConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroupConfig instanceGroupConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceGroupConfig, (String)"instanceGroupConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceGroupConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.marketAsString(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceRoleAsString(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(instanceGroupConfig.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.ebsConfiguration(), EBSCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupConfig.autoScalingPolicy(), AUTOSCALINGPOLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

