/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.FailureDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FailureDetailsMarshaller {
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reason").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<String> LOGFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogFile").isBinary(false).build();
    private static final FailureDetailsMarshaller INSTANCE = new FailureDetailsMarshaller();

    private FailureDetailsMarshaller() {
    }

    public static FailureDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FailureDetails failureDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)failureDetails, (String)"failureDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)failureDetails.reason(), REASON_BINDING);
            protocolMarshaller.marshall((Object)failureDetails.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)failureDetails.logFile(), LOGFILE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

