/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.Cluster;
import software.amazon.awssdk.services.emr.transform.ApplicationUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ClusterStatusUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ConfigurationUnmarshaller;
import software.amazon.awssdk.services.emr.transform.Ec2InstanceAttributesUnmarshaller;
import software.amazon.awssdk.services.emr.transform.KerberosAttributesUnmarshaller;
import software.amazon.awssdk.services.emr.transform.TagUnmarshaller;

public class ClusterUnmarshaller
implements Unmarshaller<Cluster, JsonUnmarshallerContext> {
    private static final ClusterUnmarshaller INSTANCE = new ClusterUnmarshaller();

    public Cluster unmarshall(JsonUnmarshallerContext context) throws Exception {
        Cluster.Builder clusterBuilder = Cluster.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.status(ClusterStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Ec2InstanceAttributes", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.ec2InstanceAttributes(Ec2InstanceAttributesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InstanceCollectionType", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.instanceCollectionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.logUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestedAmiVersion", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.requestedAmiVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RunningAmiVersion", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.runningAmiVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReleaseLabel", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.releaseLabel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoTerminate", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.autoTerminate((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("TerminationProtected", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.terminationProtected((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("VisibleToAllUsers", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.visibleToAllUsers((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Applications", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.applications(new ListUnmarshaller((Unmarshaller)ApplicationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.tags(new ListUnmarshaller((Unmarshaller)TagUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.serviceRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NormalizedInstanceHours", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.normalizedInstanceHours((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MasterPublicDnsName", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.masterPublicDnsName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.configurations(new ListUnmarshaller((Unmarshaller)ConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.securityConfiguration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoScalingRole", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.autoScalingRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScaleDownBehavior", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.scaleDownBehavior((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomAmiId", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.customAmiId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EbsRootVolumeSize", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.ebsRootVolumeSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("RepoUpgradeOnBoot", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.repoUpgradeOnBoot((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KerberosAttributes", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.kerberosAttributes(KerberosAttributesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Cluster)clusterBuilder.build();
    }

    public static ClusterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

