/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Integer> NORMALIZEDINSTANCEHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NormalizedInstanceHours").isBinary(false).build();
    private static final ClusterSummaryMarshaller INSTANCE = new ClusterSummaryMarshaller();

    private ClusterSummaryMarshaller() {
    }

    public static ClusterSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClusterSummary clusterSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)clusterSummary, (String)"clusterSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)clusterSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)clusterSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)clusterSummary.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)clusterSummary.normalizedInstanceHours(), NORMALIZEDINSTANCEHOURS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

