/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchAlarmDefinitionMarshaller {
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").isBinary(false).build();
    private static final MarshallingInfo<Integer> EVALUATIONPERIODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationPeriods").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").isBinary(false).build();
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").isBinary(false).build();
    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Period").isBinary(false).build();
    private static final MarshallingInfo<String> STATISTIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistic").isBinary(false).build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Threshold").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").isBinary(false).build();
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").isBinary(false).build();
    private static final CloudWatchAlarmDefinitionMarshaller INSTANCE = new CloudWatchAlarmDefinitionMarshaller();

    private CloudWatchAlarmDefinitionMarshaller() {
    }

    public static CloudWatchAlarmDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchAlarmDefinition cloudWatchAlarmDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchAlarmDefinition, (String)"cloudWatchAlarmDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.comparisonOperatorAsString(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.evaluationPeriods(), EVALUATIONPERIODS_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.namespace(), NAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.period(), PERIOD_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.statisticAsString(), STATISTIC_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.threshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.unitAsString(), UNIT_BINDING);
            protocolMarshaller.marshall(cloudWatchAlarmDefinition.dimensions(), DIMENSIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

