/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BootstrapActionConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCRIPTBOOTSTRAPACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScriptBootstrapAction").isBinary(false).build();
    private static final BootstrapActionConfigMarshaller INSTANCE = new BootstrapActionConfigMarshaller();

    private BootstrapActionConfigMarshaller() {
    }

    public static BootstrapActionConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BootstrapActionConfig bootstrapActionConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)bootstrapActionConfig, (String)"bootstrapActionConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)bootstrapActionConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)bootstrapActionConfig.scriptBootstrapAction(), SCRIPTBOOTSTRAPACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

