/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").isBinary(false).build();
    private static final MarshallingInfo<Map> ADDITIONALINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalInfo").isBinary(false).build();
    private static final ApplicationMarshaller INSTANCE = new ApplicationMarshaller();

    private ApplicationMarshaller() {
    }

    public static ApplicationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Application application, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)application, (String)"application");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)application.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)application.version(), VERSION_BINDING);
            protocolMarshaller.marshall(application.args(), ARGS_BINDING);
            protocolMarshaller.marshall(application.additionalInfo(), ADDITIONALINFO_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

