/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.FailureDetails;
import software.amazon.awssdk.services.emr.model.StepState;
import software.amazon.awssdk.services.emr.model.StepStateChangeReason;
import software.amazon.awssdk.services.emr.model.StepTimeline;
import software.amazon.awssdk.services.emr.transform.StepStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, StepStatus> {
    private final String state;
    private final StepStateChangeReason stateChangeReason;
    private final FailureDetails failureDetails;
    private final StepTimeline timeline;

    private StepStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.failureDetails = builder.failureDetails;
        this.timeline = builder.timeline;
    }

    public StepState state() {
        return StepState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public StepStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public StepTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepStatus)) {
            return false;
        }
        StepStatus other = (StepStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.timeline(), other.timeline());
    }

    public String toString() {
        return ToString.builder((String)"StepStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("FailureDetails", (Object)this.failureDetails()).add("Timeline", (Object)this.timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private StepStateChangeReason stateChangeReason;
        private FailureDetails failureDetails;
        private StepTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(StepStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.failureDetails(model.failureDetails);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StepState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final StepStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(StepStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(StepStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        public final StepTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(StepTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(StepTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public StepStatus build() {
            return new StepStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepStatus> {
        public Builder state(String var1);

        public Builder state(StepState var1);

        public Builder stateChangeReason(StepStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<StepStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((StepStateChangeReason)((StepStateChangeReason.Builder)StepStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder timeline(StepTimeline var1);

        default public Builder timeline(Consumer<StepTimeline.Builder> timeline) {
            return this.timeline((StepTimeline)((StepTimeline.Builder)StepTimeline.builder().applyMutation(timeline)).build());
        }
    }
}

