/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.StepSummary;
import software.amazon.awssdk.services.emr.model.StepSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStepsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListStepsResponse> {
    private final List<StepSummary> steps;
    private final String marker;

    private ListStepsResponse(BuilderImpl builder) {
        super(builder);
        this.steps = builder.steps;
        this.marker = builder.marker;
    }

    public List<StepSummary> steps() {
        return this.steps;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.steps());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsResponse)) {
            return false;
        }
        ListStepsResponse other = (ListStepsResponse)((Object)obj);
        return Objects.equals(this.steps(), other.steps()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListStepsResponse").add("Steps", this.steps()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<StepSummary> steps = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsResponse model) {
            super(model);
            this.steps(model.steps);
            this.marker(model.marker);
        }

        public final Collection<StepSummary.Builder> getSteps() {
            return this.steps != null ? (Collection)this.steps.stream().map(StepSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder steps(Collection<StepSummary> steps) {
            this.steps = StepSummaryListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepSummary ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<StepSummary.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (StepSummary)((StepSummary.Builder)StepSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSteps(Collection<StepSummary.BuilderImpl> steps) {
            this.steps = StepSummaryListCopier.copyFromBuilder(steps);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListStepsResponse build() {
            return new ListStepsResponse(this);
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    CopyableBuilder<Builder, ListStepsResponse> {
        public Builder steps(Collection<StepSummary> var1);

        public Builder steps(StepSummary ... var1);

        public Builder steps(Consumer<StepSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

