/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.InstanceGroupTypeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ListInstancesRequest> {
    private final String clusterId;
    private final String instanceGroupId;
    private final List<String> instanceGroupTypes;
    private final String instanceFleetId;
    private final String instanceFleetType;
    private final List<String> instanceStates;
    private final String marker;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceGroupTypes = builder.instanceGroupTypes;
        this.instanceFleetId = builder.instanceFleetId;
        this.instanceFleetType = builder.instanceFleetType;
        this.instanceStates = builder.instanceStates;
        this.marker = builder.marker;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public List<InstanceGroupType> instanceGroupTypes() {
        return TypeConverter.convert(this.instanceGroupTypes, InstanceGroupType::fromValue);
    }

    public List<String> instanceGroupTypesAsStrings() {
        return this.instanceGroupTypes;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeAsString() {
        return this.instanceFleetType;
    }

    public List<InstanceState> instanceStates() {
        return TypeConverter.convert(this.instanceStates, InstanceState::fromValue);
    }

    public List<String> instanceStatesAsStrings() {
        return this.instanceStates;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceGroupTypesAsStrings(), other.instanceGroupTypesAsStrings()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.instanceFleetTypeAsString(), other.instanceFleetTypeAsString()) && Objects.equals(this.instanceStatesAsStrings(), other.instanceStatesAsStrings()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListInstancesRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("InstanceGroupTypes", this.instanceGroupTypesAsStrings()).add("InstanceFleetId", (Object)this.instanceFleetId()).add("InstanceFleetType", (Object)this.instanceFleetTypeAsString()).add("InstanceStates", this.instanceStatesAsStrings()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceGroupTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupTypesAsStrings()));
            }
            case "InstanceFleetId": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetId()));
            }
            case "InstanceFleetType": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetTypeAsString()));
            }
            case "InstanceStates": {
                return Optional.ofNullable(clazz.cast(this.instanceStatesAsStrings()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private List<String> instanceGroupTypes = DefaultSdkAutoConstructList.getInstance();
        private String instanceFleetId;
        private String instanceFleetType;
        private List<String> instanceStates = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.instanceGroupTypesWithStrings(model.instanceGroupTypes);
            this.instanceFleetId(model.instanceFleetId);
            this.instanceFleetType(model.instanceFleetType);
            this.instanceStatesWithStrings(model.instanceStates);
            this.marker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final Collection<String> getInstanceGroupTypes() {
            return this.instanceGroupTypes;
        }

        @Override
        public final Builder instanceGroupTypesWithStrings(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypesWithStrings(String ... instanceGroupTypes) {
            this.instanceGroupTypesWithStrings(Arrays.asList(instanceGroupTypes));
            return this;
        }

        @Override
        public final Builder instanceGroupTypes(Collection<InstanceGroupType> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copyEnumToString(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypes(InstanceGroupType ... instanceGroupTypes) {
            this.instanceGroupTypes(Arrays.asList(instanceGroupTypes));
            return this;
        }

        public final void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Collection<String> getInstanceStates() {
            return this.instanceStates;
        }

        @Override
        public final Builder instanceStatesWithStrings(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatesWithStrings(String ... instanceStates) {
            this.instanceStatesWithStrings(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copyEnumToString(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        public final void setInstanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    CopyableBuilder<Builder, ListInstancesRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder instanceGroupTypesWithStrings(Collection<String> var1);

        public Builder instanceGroupTypesWithStrings(String ... var1);

        public Builder instanceGroupTypes(Collection<InstanceGroupType> var1);

        public Builder instanceGroupTypes(InstanceGroupType ... var1);

        public Builder instanceFleetId(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder instanceStatesWithStrings(Collection<String> var1);

        public Builder instanceStatesWithStrings(String ... var1);

        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

