/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceFleetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceFleetsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListInstanceFleetsResponse> {
    private final List<InstanceFleet> instanceFleets;
    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    public List<InstanceFleet> instanceFleets() {
        return this.instanceFleets;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleets());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse)((Object)obj);
        return Objects.equals(this.instanceFleets(), other.instanceFleets()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListInstanceFleetsResponse").add("InstanceFleets", this.instanceFleets()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleets": {
                return Optional.ofNullable(clazz.cast(this.instanceFleets()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<InstanceFleet> instanceFleets = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            super(model);
            this.instanceFleets(model.instanceFleets);
            this.marker(model.marker);
        }

        public final Collection<InstanceFleet.Builder> getInstanceFleets() {
            return this.instanceFleets != null ? (Collection)this.instanceFleets.stream().map(InstanceFleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(Consumer<InstanceFleet.Builder> ... instanceFleets) {
            this.instanceFleets(Stream.of(instanceFleets).map(c -> (InstanceFleet)((InstanceFleet.Builder)InstanceFleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        public Builder instanceFleets(Collection<InstanceFleet> var1);

        public Builder instanceFleets(InstanceFleet ... var1);

        public Builder instanceFleets(Consumer<InstanceFleet.Builder> ... var1);

        public Builder marker(String var1);
    }
}

