/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.KerberosAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KerberosAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, KerberosAttributes> {
    private final String realm;
    private final String kdcAdminPassword;
    private final String crossRealmTrustPrincipalPassword;
    private final String adDomainJoinUser;
    private final String adDomainJoinPassword;

    private KerberosAttributes(BuilderImpl builder) {
        this.realm = builder.realm;
        this.kdcAdminPassword = builder.kdcAdminPassword;
        this.crossRealmTrustPrincipalPassword = builder.crossRealmTrustPrincipalPassword;
        this.adDomainJoinUser = builder.adDomainJoinUser;
        this.adDomainJoinPassword = builder.adDomainJoinPassword;
    }

    public String realm() {
        return this.realm;
    }

    public String kdcAdminPassword() {
        return this.kdcAdminPassword;
    }

    public String crossRealmTrustPrincipalPassword() {
        return this.crossRealmTrustPrincipalPassword;
    }

    public String adDomainJoinUser() {
        return this.adDomainJoinUser;
    }

    public String adDomainJoinPassword() {
        return this.adDomainJoinPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.kdcAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossRealmTrustPrincipalPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.adDomainJoinUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.adDomainJoinPassword());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KerberosAttributes)) {
            return false;
        }
        KerberosAttributes other = (KerberosAttributes)obj;
        return Objects.equals(this.realm(), other.realm()) && Objects.equals(this.kdcAdminPassword(), other.kdcAdminPassword()) && Objects.equals(this.crossRealmTrustPrincipalPassword(), other.crossRealmTrustPrincipalPassword()) && Objects.equals(this.adDomainJoinUser(), other.adDomainJoinUser()) && Objects.equals(this.adDomainJoinPassword(), other.adDomainJoinPassword());
    }

    public String toString() {
        return ToString.builder((String)"KerberosAttributes").add("Realm", (Object)this.realm()).add("KdcAdminPassword", (Object)this.kdcAdminPassword()).add("CrossRealmTrustPrincipalPassword", (Object)this.crossRealmTrustPrincipalPassword()).add("ADDomainJoinUser", (Object)this.adDomainJoinUser()).add("ADDomainJoinPassword", (Object)this.adDomainJoinPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "KdcAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.kdcAdminPassword()));
            }
            case "CrossRealmTrustPrincipalPassword": {
                return Optional.ofNullable(clazz.cast(this.crossRealmTrustPrincipalPassword()));
            }
            case "ADDomainJoinUser": {
                return Optional.ofNullable(clazz.cast(this.adDomainJoinUser()));
            }
            case "ADDomainJoinPassword": {
                return Optional.ofNullable(clazz.cast(this.adDomainJoinPassword()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KerberosAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String realm;
        private String kdcAdminPassword;
        private String crossRealmTrustPrincipalPassword;
        private String adDomainJoinUser;
        private String adDomainJoinPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(KerberosAttributes model) {
            this.realm(model.realm);
            this.kdcAdminPassword(model.kdcAdminPassword);
            this.crossRealmTrustPrincipalPassword(model.crossRealmTrustPrincipalPassword);
            this.adDomainJoinUser(model.adDomainJoinUser);
            this.adDomainJoinPassword(model.adDomainJoinPassword);
        }

        public final String getRealm() {
            return this.realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        public final String getKdcAdminPassword() {
            return this.kdcAdminPassword;
        }

        @Override
        public final Builder kdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
            return this;
        }

        public final void setKdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
        }

        public final String getCrossRealmTrustPrincipalPassword() {
            return this.crossRealmTrustPrincipalPassword;
        }

        @Override
        public final Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
            return this;
        }

        public final void setCrossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
        }

        public final String getADDomainJoinUser() {
            return this.adDomainJoinUser;
        }

        @Override
        public final Builder adDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
            return this;
        }

        public final void setADDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
        }

        public final String getADDomainJoinPassword() {
            return this.adDomainJoinPassword;
        }

        @Override
        public final Builder adDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
            return this;
        }

        public final void setADDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
        }

        public KerberosAttributes build() {
            return new KerberosAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KerberosAttributes> {
        public Builder realm(String var1);

        public Builder kdcAdminPassword(String var1);

        public Builder crossRealmTrustPrincipalPassword(String var1);

        public Builder adDomainJoinUser(String var1);

        public Builder adDomainJoinPassword(String var1);
    }
}

