/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.JobFlowExecutionState;
import software.amazon.awssdk.services.emr.transform.JobFlowExecutionStatusDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobFlowExecutionStatusDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobFlowExecutionStatusDetail> {
    private final String state;
    private final Instant creationDateTime;
    private final Instant startDateTime;
    private final Instant readyDateTime;
    private final Instant endDateTime;
    private final String lastStateChangeReason;

    private JobFlowExecutionStatusDetail(BuilderImpl builder) {
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
        this.lastStateChangeReason = builder.lastStateChangeReason;
    }

    public JobFlowExecutionState state() {
        return JobFlowExecutionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant startDateTime() {
        return this.startDateTime;
    }

    public Instant readyDateTime() {
        return this.readyDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.readyDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowExecutionStatusDetail)) {
            return false;
        }
        JobFlowExecutionStatusDetail other = (JobFlowExecutionStatusDetail)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.readyDateTime(), other.readyDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && Objects.equals(this.lastStateChangeReason(), other.lastStateChangeReason());
    }

    public String toString() {
        return ToString.builder((String)"JobFlowExecutionStatusDetail").add("State", (Object)this.stateAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("StartDateTime", (Object)this.startDateTime()).add("ReadyDateTime", (Object)this.readyDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("LastStateChangeReason", (Object)this.lastStateChangeReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "ReadyDateTime": {
                return Optional.ofNullable(clazz.cast(this.readyDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "LastStateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.lastStateChangeReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobFlowExecutionStatusDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private Instant creationDateTime;
        private Instant startDateTime;
        private Instant readyDateTime;
        private Instant endDateTime;
        private String lastStateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowExecutionStatusDetail model) {
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
            this.startDateTime(model.startDateTime);
            this.readyDateTime(model.readyDateTime);
            this.endDateTime(model.endDateTime);
            this.lastStateChangeReason(model.lastStateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobFlowExecutionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getReadyDateTime() {
            return this.readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
            return this;
        }

        public final void setReadyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        public JobFlowExecutionStatusDetail build() {
            return new JobFlowExecutionStatusDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobFlowExecutionStatusDetail> {
        public Builder state(String var1);

        public Builder state(JobFlowExecutionState var1);

        public Builder creationDateTime(Instant var1);

        public Builder startDateTime(Instant var1);

        public Builder readyDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder lastStateChangeReason(String var1);
    }
}

