/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceTimeline;
import software.amazon.awssdk.services.emr.transform.InstanceStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceStatus> {
    private final String state;
    private final InstanceStateChangeReason stateChangeReason;
    private final InstanceTimeline timeline;

    private InstanceStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public InstanceState state() {
        return InstanceState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public InstanceStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public InstanceTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.timeline(), other.timeline());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Timeline", (Object)this.timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceStateChangeReason stateChangeReason;
        private InstanceTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final InstanceTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(InstanceTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatus> {
        public Builder state(String var1);

        public Builder state(InstanceState var1);

        public Builder stateChangeReason(InstanceStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<InstanceStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((InstanceStateChangeReason)((InstanceStateChangeReason.Builder)InstanceStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder timeline(InstanceTimeline var1);

        default public Builder timeline(Consumer<InstanceTimeline.Builder> timeline) {
            return this.timeline((InstanceTimeline)((InstanceTimeline.Builder)InstanceTimeline.builder().applyMutation(timeline)).build());
        }
    }
}

