/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetStatus;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecification;
import software.amazon.awssdk.services.emr.model.InstanceTypeSpecificationListCopier;
import software.amazon.awssdk.services.emr.transform.InstanceFleetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleet
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceFleet> {
    private final String id;
    private final String name;
    private final InstanceFleetStatus status;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final Integer provisionedOnDemandCapacity;
    private final Integer provisionedSpotCapacity;
    private final List<InstanceTypeSpecification> instanceTypeSpecifications;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;

    private InstanceFleet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.provisionedOnDemandCapacity = builder.provisionedOnDemandCapacity;
        this.provisionedSpotCapacity = builder.provisionedSpotCapacity;
        this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
        this.launchSpecifications = builder.launchSpecifications;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public InstanceFleetStatus status() {
        return this.status;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeAsString() {
        return this.instanceFleetType;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public Integer provisionedOnDemandCapacity() {
        return this.provisionedOnDemandCapacity;
    }

    public Integer provisionedSpotCapacity() {
        return this.provisionedSpotCapacity;
    }

    public List<InstanceTypeSpecification> instanceTypeSpecifications() {
        return this.instanceTypeSpecifications;
    }

    public InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleet)) {
            return false;
        }
        InstanceFleet other = (InstanceFleet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.instanceFleetTypeAsString(), other.instanceFleetTypeAsString()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity()) && Objects.equals(this.provisionedOnDemandCapacity(), other.provisionedOnDemandCapacity()) && Objects.equals(this.provisionedSpotCapacity(), other.provisionedSpotCapacity()) && Objects.equals(this.instanceTypeSpecifications(), other.instanceTypeSpecifications()) && Objects.equals(this.launchSpecifications(), other.launchSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"InstanceFleet").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("InstanceFleetType", (Object)this.instanceFleetTypeAsString()).add("TargetOnDemandCapacity", (Object)this.targetOnDemandCapacity()).add("TargetSpotCapacity", (Object)this.targetSpotCapacity()).add("ProvisionedOnDemandCapacity", (Object)this.provisionedOnDemandCapacity()).add("ProvisionedSpotCapacity", (Object)this.provisionedSpotCapacity()).add("InstanceTypeSpecifications", this.instanceTypeSpecifications()).add("LaunchSpecifications", (Object)this.launchSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "InstanceFleetType": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetTypeAsString()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetSpotCapacity()));
            }
            case "ProvisionedOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedOnDemandCapacity()));
            }
            case "ProvisionedSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedSpotCapacity()));
            }
            case "InstanceTypeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeSpecifications()));
            }
            case "LaunchSpecifications": {
                return Optional.ofNullable(clazz.cast(this.launchSpecifications()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceFleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private InstanceFleetStatus status;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private Integer provisionedOnDemandCapacity;
        private Integer provisionedSpotCapacity;
        private List<InstanceTypeSpecification> instanceTypeSpecifications = DefaultSdkAutoConstructList.getInstance();
        private InstanceFleetProvisioningSpecifications launchSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleet model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.instanceFleetType(model.instanceFleetType);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.provisionedOnDemandCapacity(model.provisionedOnDemandCapacity);
            this.provisionedSpotCapacity(model.provisionedSpotCapacity);
            this.instanceTypeSpecifications(model.instanceTypeSpecifications);
            this.launchSpecifications(model.launchSpecifications);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final InstanceFleetStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(InstanceFleetStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceFleetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public final Integer getProvisionedOnDemandCapacity() {
            return this.provisionedOnDemandCapacity;
        }

        @Override
        public final Builder provisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
            return this;
        }

        public final void setProvisionedOnDemandCapacity(Integer provisionedOnDemandCapacity) {
            this.provisionedOnDemandCapacity = provisionedOnDemandCapacity;
        }

        public final Integer getProvisionedSpotCapacity() {
            return this.provisionedSpotCapacity;
        }

        @Override
        public final Builder provisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
            return this;
        }

        public final void setProvisionedSpotCapacity(Integer provisionedSpotCapacity) {
            this.provisionedSpotCapacity = provisionedSpotCapacity;
        }

        public final Collection<InstanceTypeSpecification.Builder> getInstanceTypeSpecifications() {
            return this.instanceTypeSpecifications != null ? (Collection)this.instanceTypeSpecifications.stream().map(InstanceTypeSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copy(instanceTypeSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(InstanceTypeSpecification ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Arrays.asList(instanceTypeSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeSpecifications(Consumer<InstanceTypeSpecification.Builder> ... instanceTypeSpecifications) {
            this.instanceTypeSpecifications(Stream.of(instanceTypeSpecifications).map(c -> (InstanceTypeSpecification)((InstanceTypeSpecification.Builder)InstanceTypeSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypeSpecifications(Collection<InstanceTypeSpecification.BuilderImpl> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = InstanceTypeSpecificationListCopier.copyFromBuilder(instanceTypeSpecifications);
        }

        public final InstanceFleetProvisioningSpecifications.Builder getLaunchSpecifications() {
            return this.launchSpecifications != null ? this.launchSpecifications.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications.BuilderImpl launchSpecifications) {
            this.launchSpecifications = launchSpecifications != null ? launchSpecifications.build() : null;
        }

        public InstanceFleet build() {
            return new InstanceFleet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceFleet> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(InstanceFleetStatus var1);

        default public Builder status(Consumer<InstanceFleetStatus.Builder> status) {
            return this.status((InstanceFleetStatus)((InstanceFleetStatus.Builder)InstanceFleetStatus.builder().applyMutation(status)).build());
        }

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder provisionedOnDemandCapacity(Integer var1);

        public Builder provisionedSpotCapacity(Integer var1);

        public Builder instanceTypeSpecifications(Collection<InstanceTypeSpecification> var1);

        public Builder instanceTypeSpecifications(InstanceTypeSpecification ... var1);

        public Builder instanceTypeSpecifications(Consumer<InstanceTypeSpecification.Builder> ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);

        default public Builder launchSpecifications(Consumer<InstanceFleetProvisioningSpecifications.Builder> launchSpecifications) {
            return this.launchSpecifications((InstanceFleetProvisioningSpecifications)((InstanceFleetProvisioningSpecifications.Builder)InstanceFleetProvisioningSpecifications.builder().applyMutation(launchSpecifications)).build());
        }
    }
}

