/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringMaxLen256ListCopier;
import software.amazon.awssdk.services.emr.transform.Ec2InstanceAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2InstanceAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, Ec2InstanceAttributes> {
    private final String ec2KeyName;
    private final String ec2SubnetId;
    private final List<String> requestedEc2SubnetIds;
    private final String ec2AvailabilityZone;
    private final List<String> requestedEc2AvailabilityZones;
    private final String iamInstanceProfile;
    private final String emrManagedMasterSecurityGroup;
    private final String emrManagedSlaveSecurityGroup;
    private final String serviceAccessSecurityGroup;
    private final List<String> additionalMasterSecurityGroups;
    private final List<String> additionalSlaveSecurityGroups;

    private Ec2InstanceAttributes(BuilderImpl builder) {
        this.ec2KeyName = builder.ec2KeyName;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.requestedEc2SubnetIds = builder.requestedEc2SubnetIds;
        this.ec2AvailabilityZone = builder.ec2AvailabilityZone;
        this.requestedEc2AvailabilityZones = builder.requestedEc2AvailabilityZones;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
        this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
        this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
    }

    public String ec2KeyName() {
        return this.ec2KeyName;
    }

    public String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public List<String> requestedEc2SubnetIds() {
        return this.requestedEc2SubnetIds;
    }

    public String ec2AvailabilityZone() {
        return this.ec2AvailabilityZone;
    }

    public List<String> requestedEc2AvailabilityZones() {
        return this.requestedEc2AvailabilityZones;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String emrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public String emrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public String serviceAccessSecurityGroup() {
        return this.serviceAccessSecurityGroup;
    }

    public List<String> additionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups;
    }

    public List<String> additionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedEc2SubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedEc2AvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedMasterSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedSlaveSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMasterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalSlaveSecurityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAttributes)) {
            return false;
        }
        Ec2InstanceAttributes other = (Ec2InstanceAttributes)obj;
        return Objects.equals(this.ec2KeyName(), other.ec2KeyName()) && Objects.equals(this.ec2SubnetId(), other.ec2SubnetId()) && Objects.equals(this.requestedEc2SubnetIds(), other.requestedEc2SubnetIds()) && Objects.equals(this.ec2AvailabilityZone(), other.ec2AvailabilityZone()) && Objects.equals(this.requestedEc2AvailabilityZones(), other.requestedEc2AvailabilityZones()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.emrManagedMasterSecurityGroup(), other.emrManagedMasterSecurityGroup()) && Objects.equals(this.emrManagedSlaveSecurityGroup(), other.emrManagedSlaveSecurityGroup()) && Objects.equals(this.serviceAccessSecurityGroup(), other.serviceAccessSecurityGroup()) && Objects.equals(this.additionalMasterSecurityGroups(), other.additionalMasterSecurityGroups()) && Objects.equals(this.additionalSlaveSecurityGroups(), other.additionalSlaveSecurityGroups());
    }

    public String toString() {
        return ToString.builder((String)"Ec2InstanceAttributes").add("Ec2KeyName", (Object)this.ec2KeyName()).add("Ec2SubnetId", (Object)this.ec2SubnetId()).add("RequestedEc2SubnetIds", this.requestedEc2SubnetIds()).add("Ec2AvailabilityZone", (Object)this.ec2AvailabilityZone()).add("RequestedEc2AvailabilityZones", this.requestedEc2AvailabilityZones()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("EmrManagedMasterSecurityGroup", (Object)this.emrManagedMasterSecurityGroup()).add("EmrManagedSlaveSecurityGroup", (Object)this.emrManagedSlaveSecurityGroup()).add("ServiceAccessSecurityGroup", (Object)this.serviceAccessSecurityGroup()).add("AdditionalMasterSecurityGroups", this.additionalMasterSecurityGroups()).add("AdditionalSlaveSecurityGroups", this.additionalSlaveSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2KeyName": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyName()));
            }
            case "Ec2SubnetId": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetId()));
            }
            case "RequestedEc2SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.requestedEc2SubnetIds()));
            }
            case "Ec2AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.ec2AvailabilityZone()));
            }
            case "RequestedEc2AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.requestedEc2AvailabilityZones()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "EmrManagedMasterSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedMasterSecurityGroup()));
            }
            case "EmrManagedSlaveSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedSlaveSecurityGroup()));
            }
            case "ServiceAccessSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSecurityGroup()));
            }
            case "AdditionalMasterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalMasterSecurityGroups()));
            }
            case "AdditionalSlaveSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalSlaveSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ec2InstanceAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2KeyName;
        private String ec2SubnetId;
        private List<String> requestedEc2SubnetIds = DefaultSdkAutoConstructList.getInstance();
        private String ec2AvailabilityZone;
        private List<String> requestedEc2AvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String iamInstanceProfile;
        private String emrManagedMasterSecurityGroup;
        private String emrManagedSlaveSecurityGroup;
        private String serviceAccessSecurityGroup;
        private List<String> additionalMasterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalSlaveSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAttributes model) {
            this.ec2KeyName(model.ec2KeyName);
            this.ec2SubnetId(model.ec2SubnetId);
            this.requestedEc2SubnetIds(model.requestedEc2SubnetIds);
            this.ec2AvailabilityZone(model.ec2AvailabilityZone);
            this.requestedEc2AvailabilityZones(model.requestedEc2AvailabilityZones);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.emrManagedMasterSecurityGroup(model.emrManagedMasterSecurityGroup);
            this.emrManagedSlaveSecurityGroup(model.emrManagedSlaveSecurityGroup);
            this.serviceAccessSecurityGroup(model.serviceAccessSecurityGroup);
            this.additionalMasterSecurityGroups(model.additionalMasterSecurityGroups);
            this.additionalSlaveSecurityGroups(model.additionalSlaveSecurityGroups);
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        @Override
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        public final Collection<String> getRequestedEc2SubnetIds() {
            return this.requestedEc2SubnetIds;
        }

        @Override
        public final Builder requestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2SubnetIds(String ... requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds(Arrays.asList(requestedEc2SubnetIds));
            return this;
        }

        public final void setRequestedEc2SubnetIds(Collection<String> requestedEc2SubnetIds) {
            this.requestedEc2SubnetIds = XmlStringMaxLen256ListCopier.copy(requestedEc2SubnetIds);
        }

        public final String getEc2AvailabilityZone() {
            return this.ec2AvailabilityZone;
        }

        @Override
        public final Builder ec2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
            return this;
        }

        public final void setEc2AvailabilityZone(String ec2AvailabilityZone) {
            this.ec2AvailabilityZone = ec2AvailabilityZone;
        }

        public final Collection<String> getRequestedEc2AvailabilityZones() {
            return this.requestedEc2AvailabilityZones;
        }

        @Override
        public final Builder requestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedEc2AvailabilityZones(String ... requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones(Arrays.asList(requestedEc2AvailabilityZones));
            return this;
        }

        public final void setRequestedEc2AvailabilityZones(Collection<String> requestedEc2AvailabilityZones) {
            this.requestedEc2AvailabilityZones = XmlStringMaxLen256ListCopier.copy(requestedEc2AvailabilityZones);
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getEmrManagedMasterSecurityGroup() {
            return this.emrManagedMasterSecurityGroup;
        }

        @Override
        public final Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        public final void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
        }

        public final String getEmrManagedSlaveSecurityGroup() {
            return this.emrManagedSlaveSecurityGroup;
        }

        @Override
        public final Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        public final void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
        }

        public final String getServiceAccessSecurityGroup() {
            return this.serviceAccessSecurityGroup;
        }

        @Override
        public final Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        public final void setServiceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
        }

        public final Collection<String> getAdditionalMasterSecurityGroups() {
            return this.additionalMasterSecurityGroups;
        }

        @Override
        public final Builder additionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups(Arrays.asList(additionalMasterSecurityGroups));
            return this;
        }

        public final void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = StringListCopier.copy(additionalMasterSecurityGroups);
        }

        public final Collection<String> getAdditionalSlaveSecurityGroups() {
            return this.additionalSlaveSecurityGroups;
        }

        @Override
        public final Builder additionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups(Arrays.asList(additionalSlaveSecurityGroups));
            return this;
        }

        public final void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = StringListCopier.copy(additionalSlaveSecurityGroups);
        }

        public Ec2InstanceAttributes build() {
            return new Ec2InstanceAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ec2InstanceAttributes> {
        public Builder ec2KeyName(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder requestedEc2SubnetIds(Collection<String> var1);

        public Builder requestedEc2SubnetIds(String ... var1);

        public Builder ec2AvailabilityZone(String var1);

        public Builder requestedEc2AvailabilityZones(Collection<String> var1);

        public Builder requestedEc2AvailabilityZones(String ... var1);

        public Builder iamInstanceProfile(String var1);

        public Builder emrManagedMasterSecurityGroup(String var1);

        public Builder emrManagedSlaveSecurityGroup(String var1);

        public Builder serviceAccessSecurityGroup(String var1);

        public Builder additionalMasterSecurityGroups(Collection<String> var1);

        public Builder additionalMasterSecurityGroups(String ... var1);

        public Builder additionalSlaveSecurityGroups(Collection<String> var1);

        public Builder additionalSlaveSecurityGroups(String ... var1);
    }
}

