/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.services.emr.transform.EbsBlockDeviceConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsBlockDeviceConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsBlockDeviceConfig> {
    private final VolumeSpecification volumeSpecification;
    private final Integer volumesPerInstance;

    private EbsBlockDeviceConfig(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.volumesPerInstance = builder.volumesPerInstance;
    }

    public VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public Integer volumesPerInstance() {
        return this.volumesPerInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumesPerInstance());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDeviceConfig)) {
            return false;
        }
        EbsBlockDeviceConfig other = (EbsBlockDeviceConfig)obj;
        return Objects.equals(this.volumeSpecification(), other.volumeSpecification()) && Objects.equals(this.volumesPerInstance(), other.volumesPerInstance());
    }

    public String toString() {
        return ToString.builder((String)"EbsBlockDeviceConfig").add("VolumeSpecification", (Object)this.volumeSpecification()).add("VolumesPerInstance", (Object)this.volumesPerInstance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSpecification": {
                return Optional.ofNullable(clazz.cast(this.volumeSpecification()));
            }
            case "VolumesPerInstance": {
                return Optional.ofNullable(clazz.cast(this.volumesPerInstance()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private Integer volumesPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDeviceConfig model) {
            this.volumeSpecification(model.volumeSpecification);
            this.volumesPerInstance(model.volumesPerInstance);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return this.volumeSpecification != null ? this.volumeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        public final Integer getVolumesPerInstance() {
            return this.volumesPerInstance;
        }

        @Override
        public final Builder volumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
            return this;
        }

        public final void setVolumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
        }

        public EbsBlockDeviceConfig build() {
            return new EbsBlockDeviceConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDeviceConfig> {
        public Builder volumeSpecification(VolumeSpecification var1);

        default public Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return this.volumeSpecification((VolumeSpecification)((VolumeSpecification.Builder)VolumeSpecification.builder().applyMutation(volumeSpecification)).build());
        }

        public Builder volumesPerInstance(Integer var1);
    }
}

